/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.wizard;

import java.util.Hashtable;
import uk.org.ogsadai.tools.wizard.WizardStep;
import uk.org.ogsadai.tools.wizard.WizardUnknownStepException;

public class Wizard {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private Hashtable mSteps = new Hashtable();
    private String mCurrent = null;
    private boolean mIsFinished = false;

    public void initialise(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!this.mSteps.containsKey(string)) {
            throw new WizardUnknownStepException(string);
        }
        this.mCurrent = string;
        this.mIsFinished = false;
        ((WizardStep)this.mSteps.get(this.mCurrent)).activateStep();
        this.getCurrent().setPreviousStep(null);
    }

    public void add(WizardStep wizardStep) {
        if (wizardStep == null) {
            throw new IllegalArgumentException();
        }
        this.mSteps.put(wizardStep.getName(), wizardStep);
    }

    public void add(WizardStep[] wizardStepArray) {
        if (wizardStepArray == null) {
            throw new IllegalArgumentException();
        }
        int n = wizardStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.add(wizardStepArray[n2]);
            ++n2;
        }
    }

    public boolean next() {
        WizardStep wizardStep = this.getCurrent();
        if (wizardStep != null && wizardStep.finishStep()) {
            if (this.isNext()) {
                String string = wizardStep.getNextStep();
                String string2 = this.mCurrent;
                this.mCurrent = string;
                this.getCurrent().activateStep();
                this.getCurrent().setPreviousStep(string2);
                return true;
            }
            this.mIsFinished = true;
            return true;
        }
        return false;
    }

    public boolean back() {
        this.mIsFinished = false;
        if (this.isBack()) {
            String string;
            this.mCurrent = string = this.getCurrent().getPreviousStep();
            this.getCurrent().activateStep();
            return true;
        }
        return false;
    }

    public boolean isFinished() {
        return this.mIsFinished;
    }

    public boolean isNext() {
        String string;
        boolean bl = false;
        WizardStep wizardStep = this.getCurrent();
        if (wizardStep != null && (string = wizardStep.getNextStep()) != null) {
            if (this.mSteps.containsKey(string)) {
                bl = true;
            } else {
                throw new WizardUnknownStepException(string);
            }
        }
        return bl;
    }

    public boolean isBack() {
        String string;
        boolean bl = false;
        WizardStep wizardStep = this.getCurrent();
        if (wizardStep != null && (string = wizardStep.getPreviousStep()) != null) {
            if (this.mSteps.containsKey(string)) {
                bl = true;
            } else {
                throw new WizardUnknownStepException(string);
            }
        }
        return bl;
    }

    public WizardStep getCurrent() {
        if (this.mCurrent != null) {
            return (WizardStep)this.mSteps.get(this.mCurrent);
        }
        return null;
    }

    public String getCurrentName() {
        return this.mCurrent;
    }
}

