/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.wizard;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import uk.org.ogsadai.tools.gui.wizard.JWizardStepAbstract;

public class JWizardProperties
extends JWizardStepAbstract {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private JPanel mPanel;
    private JTextArea mCurrent;
    private JButton mSelect;
    private String mProperty;
    private boolean mIsALoad = true;
    private String[] mSaveProperties = null;

    public String getProperty() {
        return this.mProperty;
    }

    public void setProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mProperty = string;
    }

    public void setLoad(boolean bl) {
        this.mIsALoad = bl;
    }

    public void setSaveProperties(String[] stringArray) {
        this.mSaveProperties = stringArray;
    }

    public JWizardProperties(Properties properties, String string) {
        super(properties);
        this.setProperty(string);
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new FlowLayout());
        this.mPanel.add((Component)new JLabel("Path: "), 0);
        this.mCurrent = new JTextArea(2, 40);
        this.mCurrent.setEditable(false);
        this.mPanel.add(this.mCurrent);
        this.mSelect = this.getSelectButton();
        this.mPanel.add(this.mSelect);
    }

    private JButton getSelectButton() {
        JButton jButton = new JButton("Select...");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizardProperties.this.select();
            }
        });
        jButton.setToolTipText("Select a file/directory");
        jButton.setMnemonic(83);
        return jButton;
    }

    private void select() {
        String string = this.mProperties.getProperty(this.mProperty);
        JFileChooser jFileChooser = new JFileChooser(string);
        int n = jFileChooser.showDialog(this.mPanel, "Select");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string2 = file.getAbsolutePath();
            this.mProperties.setProperty(this.mProperty, string2);
            this.mCurrent.setText(string2);
        }
    }

    public boolean finishStep() {
        String string = this.mProperties.getProperty(this.mProperty);
        if (string == null || string.equals("")) {
            this.showError("Oops!", "Please select a file!");
            return false;
        }
        File file = new File(string);
        if (file == null || file.isDirectory()) {
            this.showError("Oops!", "Please select a file!");
            return false;
        }
        if (this.mIsALoad) {
            return this.loadProperties(file);
        }
        return this.saveProperties(file);
    }

    public JComponent getWizardStepComponent() {
        return this.mPanel;
    }

    private void showError(String string, String string2) {
        JOptionPane.showMessageDialog(this.mPanel, string2, string, 0);
    }

    private boolean saveProperties(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            Object[] objectArray = this.mSaveProperties == null ? this.mProperties.keySet().toArray() : this.mSaveProperties;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = (String)objectArray[n2];
                String string2 = this.mProperties.getProperty(string);
                if (string2 != null) {
                    outputStreamWriter.write(string);
                    outputStreamWriter.write("=");
                    String string3 = string2.replace('\\', '/');
                    outputStreamWriter.write(string3);
                    outputStreamWriter.write("\n");
                }
                ++n2;
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.showError("Save Error!", "Your file cannot be saved for some reason" + iOException.getMessage());
            return false;
        }
        return true;
    }

    private boolean loadProperties(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.mProperties.load(fileInputStream);
        }
        catch (IOException iOException) {
            this.showError("Save Error!", "Your file cannot be loaded for some reason" + iOException.getMessage());
            return false;
        }
        return true;
    }

    public void activateStep() {
        String string = this.mProperties.getProperty(this.mProperty);
        this.mCurrent.setText(string);
    }
}

