/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Properties;
import java.util.Vector;
import uk.org.ogsadai.tools.general.Categories;
import uk.org.ogsadai.tools.general.Category;
import uk.org.ogsadai.tools.general.PropertyEntry;
import uk.org.ogsadai.tools.gui.wizard.JWizard;
import uk.org.ogsadai.tools.gui.wizard.JWizardANT;
import uk.org.ogsadai.tools.gui.wizard.JWizardCategorySelector;
import uk.org.ogsadai.tools.gui.wizard.JWizardFileSelect;
import uk.org.ogsadai.tools.gui.wizard.JWizardInfo;
import uk.org.ogsadai.tools.gui.wizard.JWizardMultipleFileSelect;
import uk.org.ogsadai.tools.gui.wizard.JWizardProperties;
import uk.org.ogsadai.tools.gui.wizard.JWizardPropertyEditor;
import uk.org.ogsadai.tools.gui.wizard.JWizardStep;
import uk.org.ogsadai.tools.gui.wizard.JWizardStepAbstract;
import uk.org.ogsadai.tools.wizard.Wizard;

public class JWizardParser {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private static final String END_CHUNK = "END";
    private Wizard mWizard;
    private JWizard mJWizard;
    private Vector mLines;
    private int mCurrentLine = -1;
    private int mNumLines = -1;

    public void parse(String string, Properties properties) throws IOException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Missing file!");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Missing properties!");
        }
        FileInputStream fileInputStream = null;
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File " + string + " either does not exist or is not a file!");
        }
        fileInputStream = new FileInputStream(string);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        this.getLines(lineNumberReader);
        this.parse(properties);
    }

    public Wizard getWizard() {
        return this.mWizard;
    }

    public JWizard getJWizard() {
        return this.mJWizard;
    }

    private void getLines(LineNumberReader lineNumberReader) throws IOException {
        this.mLines = new Vector();
        String string = lineNumberReader.readLine();
        while (string != null) {
            this.mLines.add(string);
            string = lineNumberReader.readLine();
        }
        this.mNumLines = this.mLines.size();
    }

    private String getLine() {
        ++this.mCurrentLine;
        while (this.mCurrentLine < this.mNumLines) {
            String string = (String)this.mLines.get(this.mCurrentLine);
            if (!string.equals("") && !string.startsWith("#")) {
                return string;
            }
            ++this.mCurrentLine;
        }
        return null;
    }

    private String getChunk() {
        ++this.mCurrentLine;
        ++this.mCurrentLine;
        String string = (String)this.mLines.get(this.mCurrentLine);
        StringBuffer stringBuffer = new StringBuffer();
        while (string != null && !string.equals(END_CHUNK)) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
            ++this.mCurrentLine;
            string = (String)this.mLines.get(this.mCurrentLine);
        }
        return stringBuffer.toString();
    }

    private void parse(Properties properties) {
        String string = this.getLine();
        String string2 = "";
        String string3 = "";
        this.mWizard = new Wizard();
        while (string != null) {
            if (string.startsWith("dialog=")) {
                string2 = string.substring(7);
            } else if (string.startsWith("firstStep=")) {
                string3 = string.substring(10);
            } else if (string.startsWith("step=selectFile")) {
                this.mWizard.add(this.getFileSelectStep(properties));
            } else if (string.startsWith("step=selectMultipleFiles")) {
                this.mWizard.add(this.getMultipleFileSelectStep(properties));
            } else if (string.startsWith("step=selectCategory")) {
                this.mWizard.add(this.getCategorySelectStep(properties));
            } else if (string.startsWith("step=editProperties")) {
                this.mWizard.add(this.getEditPropertiesStep(properties));
            } else if (string.startsWith("step=invokeANT")) {
                this.mWizard.add(this.getInvokeANTStep(properties));
            } else if (string.startsWith("step=displayInfo")) {
                this.mWizard.add(this.getInfoStep(properties));
            } else if (string.startsWith("step=properties")) {
                this.mWizard.add(this.getPropertiesStep(properties));
            }
            string = this.getLine();
        }
        this.mWizard.initialise(string3);
        this.mJWizard = new JWizard(string2, this.mWizard);
    }

    private JWizardStep getFileSelectStep(Properties properties) {
        String string = this.getLine().substring(5);
        String string2 = this.getLine().substring(8);
        String string3 = this.getChunk();
        String string4 = this.getLine().substring(9);
        String string5 = this.getLine().substring(9);
        String string6 = properties.getProperty(string5);
        if (string6 == null) {
            properties.setProperty(string5, "");
        }
        String string7 = this.getLine().substring(10);
        JWizardFileSelect jWizardFileSelect = new JWizardFileSelect(properties, string5);
        jWizardFileSelect.setDirectory(new Boolean(string7));
        jWizardFileSelect.setName(string);
        jWizardFileSelect.setStepSummary(string2);
        jWizardFileSelect.setStepDescription(string3);
        jWizardFileSelect.setConditionalNextStep(string4);
        return jWizardFileSelect;
    }

    private JWizardStep getMultipleFileSelectStep(Properties properties) {
        String string = this.getLine().substring(5);
        String string2 = this.getLine().substring(8);
        String string3 = this.getChunk();
        String string4 = this.getLine().substring(9);
        String string5 = this.getLine().substring(9);
        String string6 = properties.getProperty(string5);
        if (string6 == null) {
            properties.setProperty(string5, "");
        }
        String string7 = this.getLine().substring(10);
        JWizardMultipleFileSelect jWizardMultipleFileSelect = new JWizardMultipleFileSelect(properties, string5);
        jWizardMultipleFileSelect.setDelimiter(string7);
        jWizardMultipleFileSelect.setName(string);
        jWizardMultipleFileSelect.setStepSummary(string2);
        jWizardMultipleFileSelect.setStepDescription(string3);
        jWizardMultipleFileSelect.setConditionalNextStep(string4);
        return jWizardMultipleFileSelect;
    }

    private JWizardStep getPropertiesStep(Properties properties) {
        String[] stringArray;
        String string = this.getLine().substring(5);
        String string2 = this.getLine().substring(8);
        String string3 = this.getChunk();
        String string4 = this.getLine().substring(9);
        String string5 = this.getLine().substring(9);
        String string6 = properties.getProperty(string5);
        if (string6 == null) {
            properties.setProperty(string5, "");
        }
        String string7 = this.getLine().substring(8);
        String string8 = this.getLine().substring(14);
        if (string8.equals("all")) {
            stringArray = null;
        } else {
            int n = new Integer(string8);
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.getLine();
                ++n2;
            }
        }
        JWizardProperties jWizardProperties = new JWizardProperties(properties, string5);
        jWizardProperties.setLoad(new Boolean(string7));
        jWizardProperties.setName(string);
        jWizardProperties.setStepSummary(string2);
        jWizardProperties.setStepDescription(string3);
        jWizardProperties.setSaveProperties(stringArray);
        jWizardProperties.setConditionalNextStep(string4);
        return jWizardProperties;
    }

    private JWizardStep getCategorySelectStep(Properties properties) {
        Object object;
        String string;
        String string2;
        String string3 = this.getLine().substring(5);
        String string4 = this.getLine().substring(8);
        String string5 = this.getChunk();
        String string6 = this.getLine().substring(9);
        String string7 = this.getLine().substring(9);
        String string8 = properties.getProperty(string7);
        if (string8 == null) {
            properties.setProperty(string7, "");
        }
        if ((string2 = properties.getProperty(string = this.getLine().substring(12))) == null) {
            properties.setProperty(string, "");
        }
        String string9 = this.getLine().substring(14);
        int n = new Integer(string9);
        Categories[] categoriesArray = new Categories[n];
        int n2 = 0;
        while (n2 < n) {
            object = new Categories();
            categoriesArray[n2] = object;
            String string10 = this.getLine().substring(9);
            ((Categories)object).setName(string10);
            String string11 = this.getLine().substring(17);
            int n3 = new Integer(string11);
            int n4 = 0;
            while (n4 < n3) {
                Category category = new Category();
                ((Categories)object).addCategory(category);
                String string12 = this.getLine().substring(12);
                category.setName(string12);
                String string13 = this.getLine().substring(14);
                int n5 = new Integer(string13);
                Properties properties2 = new Properties();
                int n6 = 0;
                while (n6 < n5) {
                    String string14 = this.getLine();
                    int n7 = string14.indexOf("=");
                    properties2.setProperty(string14.substring(0, n7), string14.substring(n7 + 1, string14.length()));
                    ++n6;
                }
                category.setProperties(properties2);
                ++n4;
            }
            ++n2;
        }
        object = new JWizardCategorySelector(categoriesArray, string7, string, properties);
        ((JWizardCategorySelector)object).setTitle(string4);
        ((JWizardStepAbstract)object).setName(string3);
        ((JWizardStepAbstract)object).setStepSummary(string4);
        ((JWizardStepAbstract)object).setStepDescription(string5);
        ((JWizardStepAbstract)object).setConditionalNextStep(string6);
        return object;
    }

    private JWizardStep getEditPropertiesStep(Properties properties) {
        Object object;
        String string = this.getLine().substring(5);
        String string2 = this.getLine().substring(8);
        String string3 = this.getChunk();
        String string4 = this.getLine().substring(9);
        String string5 = this.getLine().substring(14);
        int n = new Integer(string5);
        PropertyEntry[] propertyEntryArray = new PropertyEntry[n];
        int n2 = 0;
        while (n2 < n) {
            object = this.getLine().substring(9);
            String string6 = this.getLine().substring(8);
            String string7 = this.getLine().substring(5);
            String string8 = this.getLine().substring(9);
            String string9 = this.getLine().substring(12);
            PropertyEntry propertyEntry = new PropertyEntry();
            propertyEntry.setName((String)object);
            propertyEntry.setSummary(string6);
            propertyEntry.setDescription(string9);
            propertyEntry.setType(string7);
            propertyEntry.setIsOptional(new Boolean(string8));
            propertyEntryArray[n2] = propertyEntry;
            String string10 = properties.getProperty((String)object);
            if (string10 == null) {
                properties.setProperty((String)object, "");
            }
            ++n2;
        }
        object = new JWizardPropertyEditor(properties, propertyEntryArray);
        ((JWizardPropertyEditor)object).setTitle(string2);
        ((JWizardStepAbstract)object).setName(string);
        ((JWizardStepAbstract)object).setStepSummary(string2);
        ((JWizardStepAbstract)object).setStepDescription(string3);
        ((JWizardStepAbstract)object).setConditionalNextStep(string4);
        return object;
    }

    private JWizardStep getInfoStep(Properties properties) {
        String string = this.getLine().substring(5);
        String string2 = this.getLine().substring(8);
        String string3 = this.getChunk();
        String string4 = this.getLine().substring(9);
        JWizardInfo jWizardInfo = new JWizardInfo(properties);
        jWizardInfo.setName(string);
        jWizardInfo.setStepSummary(string2);
        jWizardInfo.setStepDescription(string3);
        jWizardInfo.setConditionalNextStep(string4);
        return jWizardInfo;
    }

    private JWizardStep getInvokeANTStep(Properties properties) {
        JWizardANT jWizardANT;
        String string = this.getLine().substring(5);
        String string2 = this.getLine().substring(8);
        String string3 = this.getChunk();
        String string4 = this.getLine().substring(9);
        String string5 = this.getLine().substring(9);
        String string6 = this.getLine().substring(10);
        String string7 = this.getLine().substring(5);
        String string8 = this.getLine().substring(7);
        String string9 = this.getLine().substring(14);
        if (string9.equals("none")) {
            jWizardANT = new JWizardANT(properties, string7, string8, false);
        } else if (string9.equals("all")) {
            jWizardANT = new JWizardANT(properties, string7, string8, true);
        } else {
            int n = new Integer(string9);
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.getLine();
                ++n2;
            }
            jWizardANT = new JWizardANT(properties, string7, string8, stringArray);
        }
        jWizardANT.setCanSkip(new Boolean(string5));
        jWizardANT.setUserSkip(new Boolean(string6));
        jWizardANT.setName(string);
        jWizardANT.setStepSummary(string2);
        jWizardANT.setStepDescription(string3);
        jWizardANT.setConditionalNextStep(string4);
        return jWizardANT;
    }
}

