/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.org.ogsadai.tools.gui.wizard.JWizardStepAbstract;

public class JWizardMultipleFileSelect
extends JWizardStepAbstract {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private JFileChooser mFileChooser;
    private JPanel mContainer;
    private String mProperty;
    private String mDelimiter = ";";
    private JButton mAddButton;
    private JButton mRemoveButton;
    private JList mFileList;
    private DefaultListModel mModel;

    public String getProperty() {
        return this.mProperty;
    }

    public void setProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mProperty = string;
    }

    public String getDelimiter() {
        return this.mDelimiter;
    }

    public void setDelimiter(String string) {
        this.mDelimiter = string;
    }

    public JWizardMultipleFileSelect(Properties properties, String string) {
        super(properties);
        this.setProperty(string);
        this.mFileChooser = new JFileChooser();
        this.mFileChooser.setControlButtonsAreShown(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.mAddButton = this.getAddButton();
        jPanel.add(this.mAddButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.mFileChooser, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.mRemoveButton = this.getRemoveButton();
        jPanel.add(this.mRemoveButton);
        this.mModel = new DefaultListModel();
        this.mFileList = new JList(this.mModel);
        JScrollPane jScrollPane = new JScrollPane(this.mFileList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Selected Files"), "North");
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel, "South");
        this.mContainer = new JPanel();
        this.mContainer.setLayout(new GridLayout(0, 2));
        this.mContainer.add(jPanel2);
        this.mContainer.add(jPanel3);
    }

    private JButton getAddButton() {
        JButton jButton = new JButton("Add");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizardMultipleFileSelect.this.add();
            }
        });
        jButton.setToolTipText("Add selected file to list");
        jButton.setMnemonic(65);
        return jButton;
    }

    private JButton getRemoveButton() {
        JButton jButton = new JButton("Remove");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizardMultipleFileSelect.this.remove();
            }
        });
        jButton.setToolTipText("Remove selected file from list");
        jButton.setMnemonic(82);
        return jButton;
    }

    private void add() {
        try {
            File file = this.mFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            this.mModel.addElement(string);
        }
        catch (Exception exception) {}
    }

    private void remove() {
        int n = this.mFileList.getSelectedIndex();
        if (n > -1) {
            this.mModel.removeElementAt(n);
        }
    }

    public boolean finishStep() {
        boolean bl = true;
        int n = 0;
        while (bl) {
            String string = this.mProperties.getProperty(this.mProperty + "." + n);
            if (string == null || string.equals("")) {
                bl = false;
                continue;
            }
            this.mProperties.remove(this.mProperty + "." + n);
            ++n;
        }
        int n2 = this.mModel.size();
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while (n < n2) {
            String string = (String)this.mModel.get(n);
            stringBuffer.append(string);
            stringBuffer.append(this.mDelimiter);
            this.mProperties.setProperty(this.mProperty + "." + n, string);
            ++n;
        }
        this.mProperties.setProperty(this.mProperty, stringBuffer.toString());
        return true;
    }

    public JComponent getWizardStepComponent() {
        return this.mContainer;
    }

    public void activateStep() {
        this.mModel.clear();
        int n = this.mModel.size();
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            String string = this.mProperties.getProperty(this.mProperty + "." + n2);
            if (string == null || string.equals("")) {
                bl = false;
                continue;
            }
            this.mModel.addElement(string);
            ++n2;
        }
    }
}

