/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.wizard;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import uk.org.ogsadai.tools.gui.wizard.JWizardStepAbstract;

public class JWizardFileSelect
extends JWizardStepAbstract {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private JPanel mPanel;
    private JTextArea mCurrent;
    private JButton mSelect;
    private String mProperty;
    private boolean mIsDirectory = false;

    public String getProperty() {
        return this.mProperty;
    }

    public void setProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mProperty = string;
    }

    public boolean getDirectory() {
        return this.mIsDirectory;
    }

    public void setDirectory(boolean bl) {
        this.mIsDirectory = bl;
    }

    public JWizardFileSelect(Properties properties, String string) {
        super(properties);
        this.setProperty(string);
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new FlowLayout());
        this.mPanel.add((Component)new JLabel("Path: "), 0);
        Font font = this.mPanel.getFont();
        this.mCurrent = new JTextArea(2, 40);
        this.mCurrent.setEditable(false);
        this.mCurrent.setFont(font);
        this.mPanel.add(this.mCurrent);
        this.mPanel.add(this.getSelectButton());
    }

    private JButton getSelectButton() {
        JButton jButton = new JButton("Select...");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizardFileSelect.this.select();
            }
        });
        jButton.setToolTipText("Select a file/directory");
        jButton.setMnemonic(83);
        return jButton;
    }

    private void select() {
        String string = this.mProperties.getProperty(this.mProperty);
        JFileChooser jFileChooser = new JFileChooser(string);
        if (this.mIsDirectory) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileSelectionMode(0);
        }
        int n = jFileChooser.showDialog(this.mPanel, "Select");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string2 = file.getAbsolutePath();
            this.mProperties.setProperty(this.mProperty, string2);
            this.mCurrent.setText(string2);
        }
    }

    public boolean finishStep() {
        String string = this.mProperties.getProperty(this.mProperty);
        if (string == null || string.equals("")) {
            if (this.mIsDirectory) {
                this.showError("Please select a directory!");
            } else {
                this.showError("Please select a file!");
            }
            return false;
        }
        File file = new File(string);
        if (this.mIsDirectory) {
            if (file == null || !file.isDirectory()) {
                this.showError("Please select a directory!");
                return false;
            }
        } else if (file == null || file.isDirectory()) {
            this.showError("Please select a file!");
            return false;
        }
        return true;
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this.mPanel, string, "Oops!", 0);
    }

    public JComponent getWizardStepComponent() {
        return this.mPanel;
    }

    public void activateStep() {
        String string = this.mProperties.getProperty(this.mProperty);
        this.mCurrent.setText(string);
        this.mPanel.invalidate();
        this.mPanel.repaint();
    }
}

