/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import uk.org.ogsadai.tools.gui.wizard.JWizardStepAbstract;

public class JWizardANT
extends JWizardStepAbstract
implements BuildListener {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private static final String ECHO = "echo";
    private String mTarget = "";
    private String mFile = "build.xml";
    private boolean mCanSkip = false;
    private boolean mUserSkip = true;
    private JTextArea mInfoArea;
    private JScrollPane mScrollPane;
    private TitledBorder mBorder;
    private JPanel mPanel;
    private JProgressBar mProgressBar;
    private JCheckBox mSkip;
    private String[] mANTProperties = null;
    private boolean mSendAll = false;

    public String getTarget() {
        return this.mTarget;
    }

    public void setTarget(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mTarget = string;
    }

    public String getFile() {
        return this.mFile;
    }

    public void setFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mFile = string;
    }

    public void setCanSkip(boolean bl) {
        this.mCanSkip = bl;
    }

    public void setUserSkip(boolean bl) {
        this.mUserSkip = bl;
    }

    public void setANTProperties(String[] stringArray) {
        this.mANTProperties = stringArray;
    }

    public JWizardANT(Properties properties, String string, String string2, boolean bl) {
        this(properties, string, string2, null);
        this.mSendAll = bl;
    }

    public JWizardANT(Properties properties, String string, boolean bl) {
        this(properties, string, null);
        this.mSendAll = bl;
    }

    public JWizardANT(Properties properties, String string, String[] stringArray) {
        this(properties, "build.xml", string, stringArray);
    }

    public JWizardANT(Properties properties, String string, String string2, String[] stringArray) {
        super(properties);
        this.setTarget(string2);
        this.setFile(string);
        this.setANTProperties(stringArray);
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        this.mBorder = BorderFactory.createTitledBorder("");
        this.mPanel.setBorder(this.mBorder);
        Font font = this.mPanel.getFont();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel("Progress:"));
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setAlignmentX(0.0f);
        jPanel.add(this.mProgressBar);
        box.add(jPanel);
        this.mInfoArea = new JTextArea(10, 40);
        this.mInfoArea.setEditable(false);
        this.mInfoArea.setLineWrap(true);
        this.mInfoArea.setWrapStyleWord(true);
        this.mInfoArea.setFont(font);
        this.mScrollPane = new JScrollPane(this.mInfoArea);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mPanel.add((Component)box, "North");
        this.mPanel.add((Component)this.mScrollPane, "Center");
        this.mSkip = this.getSkipButton();
        this.mPanel.add((Component)this.mSkip, "South");
    }

    private JCheckBox getSkipButton() {
        JCheckBox jCheckBox = new JCheckBox("Skip", this.mUserSkip);
        jCheckBox.setEnabled(true);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizardANT.this.skipButton();
            }
        });
        jCheckBox.setToolTipText("Opt to skip this step");
        jCheckBox.setMnemonic(83);
        return jCheckBox;
    }

    private void skipButton() {
        this.mUserSkip = !this.mUserSkip;
    }

    public boolean finishStep() {
        if (this.mUserSkip && this.mCanSkip) {
            return true;
        }
        Project project = new Project();
        try {
            int n;
            Object object;
            String string;
            this.mProgressBar.setIndeterminate(true);
            String string2 = this.mProperties.getProperty(this.mFile);
            if (string2 == null) {
                string2 = this.mFile;
            }
            if ((string = this.mProperties.getProperty(this.mTarget)) == null) {
                string = this.mTarget;
            }
            Project project2 = new Project();
            project2.setCoreLoader(null);
            project2.fireBuildStarted();
            project2.init();
            String[] stringArray = null;
            if (this.mANTProperties != null) {
                stringArray = this.mANTProperties;
            } else if (this.mSendAll) {
                object = this.mProperties.keySet().toArray();
                n = ((Object[])object).length;
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = (String)object[n2];
                    ++n2;
                }
            }
            if (stringArray != null) {
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String string3 = this.mProperties.getProperty(stringArray[n]);
                    if (string3 != null) {
                        project2.setUserProperty(stringArray[n], string3);
                    }
                    ++n;
                }
            }
            object = new File(string2);
            project2.setUserProperty("ant.file", ((File)object).getAbsolutePath());
            ProjectHelper.configureProject((Project)project2, (File)object);
            project2.addBuildListener((BuildListener)this);
            project2.executeTarget(string);
            this.mProgressBar.setIndeterminate(false);
            project.removeBuildListener((BuildListener)this);
            JOptionPane.showMessageDialog(this.mPanel, this.getStepSummary() + " completed!", "Completed!", 1);
            return true;
        }
        catch (Exception exception) {
            this.addInformation(exception.getMessage());
            exception.printStackTrace();
            project.removeBuildListener((BuildListener)this);
            this.mProgressBar.setIndeterminate(false);
            JOptionPane.showMessageDialog(this.mPanel, "A problem was encountered!\nCheck the main window for details.", "Oops!", 0);
            return false;
        }
    }

    public JComponent getWizardStepComponent() {
        return this.mPanel;
    }

    public void activateStep() {
        if (this.mCanSkip) {
            this.mSkip.setText("Skip " + this.getStepSummary());
            this.mSkip.setSelected(this.mUserSkip);
        } else {
            this.mSkip.setVisible(false);
        }
        this.mBorder.setTitle(this.getStepSummary());
        this.mInfoArea.selectAll();
        this.mInfoArea.replaceSelection("");
    }

    private void addInformation(String string) {
        if (string != null) {
            this.mInfoArea.append(string);
            this.mInfoArea.append("\n");
            this.mInfoArea.setCaretPosition(this.mInfoArea.getDocument().getLength());
            this.mInfoArea.setForeground(Color.BLACK);
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
        Task task = buildEvent.getTask();
        if (task != null && buildEvent.getTask().getTaskName().equals(ECHO)) {
            this.addInformation(buildEvent.getMessage());
        }
    }
}

