/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import uk.org.ogsadai.tools.gui.GUIThread;
import uk.org.ogsadai.tools.gui.wizard.JWizardStep;
import uk.org.ogsadai.tools.wizard.Wizard;
import uk.org.ogsadai.tools.wizard.WizardStep;

public class JWizard
extends JFrame {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private Wizard mWizard;
    private String mTitle;
    private JButton mButtonNext;
    private JButton mButtonBack;
    private JButton mButtonCancel;
    private JButton mButtonFinish;
    private JLabel mLabel;
    private JPanel mStepPanel;
    private JTextArea mDescArea;
    static /* synthetic */ Class class$uk$org$ogsadai$tools$gui$wizard$JWizardStep;

    public JWizard(String string, Wizard wizard) {
        super(string);
        this.mTitle = string;
        if (wizard == null) {
            throw new IllegalArgumentException();
        }
        this.mWizard = wizard;
        this.setSize(640, 480);
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        Border border = BorderFactory.createLineBorder(Color.black);
        jPanel2.setBorder(border);
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        this.mLabel = new JLabel();
        Font font = this.mLabel.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), 20);
        this.mLabel.setFont(font2);
        jPanel2.add((Component)this.mLabel, "North");
        this.mDescArea = new JTextArea();
        this.mDescArea.setRows(3);
        this.mDescArea.setEditable(false);
        this.mDescArea.setWrapStyleWord(true);
        this.mDescArea.setLineWrap(true);
        this.mDescArea.setBackground(jPanel2.getBackground());
        this.mDescArea.setFont(font);
        jPanel2.add((Component)this.mDescArea, "Center");
        this.mStepPanel = new JPanel();
        this.mStepPanel.setLayout(new BorderLayout());
        this.mStepPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.mStepPanel, "Center");
        Box box = Box.createHorizontalBox();
        this.mButtonBack = this.getBackButton();
        this.mButtonNext = this.getNextButton();
        this.mButtonCancel = this.getCancelButton();
        this.mButtonFinish = this.getFinishButton();
        box.add(this.mButtonBack);
        box.add(this.mButtonNext);
        box.add(this.mButtonFinish);
        box.add(Box.createHorizontalGlue());
        box.add(this.mButtonCancel);
        jPanel.add((Component)box, "South");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.updateState();
    }

    private JButton getNextButton() {
        JButton jButton = new JButton("Next");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizard.this.nextButton();
            }
        });
        jButton.setToolTipText("Go on to next step");
        jButton.setMnemonic(78);
        return jButton;
    }

    private JButton getBackButton() {
        JButton jButton = new JButton("Back");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizard.this.backButton();
            }
        });
        jButton.setToolTipText("Go back to previous step");
        jButton.setMnemonic(66);
        return jButton;
    }

    private JButton getFinishButton() {
        JButton jButton = new JButton("Finish");
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizard.this.finishButton();
            }
        });
        jButton.setToolTipText("Finish");
        jButton.setMnemonic(70);
        return jButton;
    }

    private JButton getCancelButton() {
        JButton jButton = new JButton("Cancel");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWizard.this.cancelButton();
            }
        });
        jButton.setToolTipText("Cancel");
        jButton.setMnemonic(67);
        return jButton;
    }

    private void finishButton() {
        this.nextButton();
    }

    private void nextButton() {
        GUIThread gUIThread = new GUIThread(){

            public Object setup() {
                JWizard.this.enableButtons(false);
                JWizard.this.mWizard.next();
                JWizard.this.enableButtons(true);
                JWizard.this.updateState();
                return null;
            }
        };
        gUIThread.start();
    }

    private void backButton() {
        this.mWizard.back();
        this.updateState();
    }

    private void cancelButton() {
        this.setVisible(false);
        this.dispose();
    }

    private void enableButtons(boolean bl) {
        this.mButtonNext.setEnabled(bl && this.mWizard.isNext());
        this.mButtonCancel.setEnabled(bl);
        this.mButtonFinish.setEnabled(bl && !this.mWizard.isNext());
        this.mButtonBack.setEnabled(bl && this.mWizard.isBack());
    }

    private void updateState() {
        WizardStep wizardStep;
        this.mButtonNext.setEnabled(this.mWizard.isNext());
        this.mButtonFinish.setEnabled(!this.mWizard.isNext());
        if (this.mWizard.isFinished()) {
            this.setVisible(false);
            this.dispose();
        }
        if ((class$uk$org$ogsadai$tools$gui$wizard$JWizardStep == null ? (class$uk$org$ogsadai$tools$gui$wizard$JWizardStep = JWizard.class$("uk.org.ogsadai.tools.gui.wizard.JWizardStep")) : class$uk$org$ogsadai$tools$gui$wizard$JWizardStep).isInstance(wizardStep = this.mWizard.getCurrent())) {
            JWizardStep jWizardStep = (JWizardStep)wizardStep;
            this.mStepPanel.removeAll();
            this.mStepPanel.add((Component)jWizardStep.getWizardStepComponent(), "Center");
            this.mLabel.setText(jWizardStep.getStepSummary());
            this.mStepPanel.repaint();
            this.mDescArea.setText(jWizardStep.getStepDescription().trim());
            this.mDescArea.repaint();
            this.mButtonBack.setEnabled(this.mWizard.isBack());
            this.validate();
            this.repaint();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

