/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import uk.org.ogsadai.tools.general.PropertyEntry;
import uk.org.ogsadai.tools.general.StringValidator;

public class JPropertiesPanel
extends JPanel {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private Properties mProperties = null;
    private PropertyEntry[] mEntries = null;
    private JPanel mPropertiesPanel = new JPanel();
    private JComponent[] mPropertyFields = null;
    private TitledBorder mTitleBorder;

    public JPropertiesPanel(Properties properties, PropertyEntry[] propertyEntryArray) {
        if (properties == null || propertyEntryArray == null) {
            throw new IllegalArgumentException();
        }
        this.mProperties = properties;
        this.mEntries = propertyEntryArray;
        this.mTitleBorder = BorderFactory.createTitledBorder("");
        super.setBorder(this.mTitleBorder);
        super.setLayout(new BorderLayout());
        this.refresh();
    }

    public void setTitle(String string) {
        this.mTitleBorder.setTitle(string);
        this.repaint();
    }

    public void refresh() {
        if (this.mPropertiesPanel != null) {
            super.remove(this.mPropertiesPanel);
        }
        this.mPropertiesPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPropertiesPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        int n = this.mEntries.length;
        this.mPropertyFields = new JComponent[n];
        int n2 = 0;
        while (n2 < n) {
            JComponent jComponent;
            PropertyEntry propertyEntry = this.mEntries[n2];
            String string = this.mProperties.getProperty(propertyEntry.getName());
            JLabel jLabel = new JLabel(propertyEntry.getSummary());
            if (propertyEntry.getType().equals("boolean") || propertyEntry.getType().equals("yesno")) {
                jComponent = new JCheckBox();
                jComponent.setSelected(new Boolean(string));
            } else {
                if (propertyEntry.getType().equals("password")) {
                    jComponent = new JPasswordField();
                    ((JPasswordField)jComponent).setEchoChar('*');
                } else {
                    jComponent = new JTextField(20);
                }
                if (string != null) {
                    ((JTextField)jComponent).setText(string);
                }
            }
            jComponent.setToolTipText(propertyEntry.getDescription());
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            this.mPropertiesPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.mPropertiesPanel.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 2;
            if (propertyEntry.isOptional()) {
                this.mPropertiesPanel.add((Component)new JLabel("          "), gridBagConstraints);
            } else {
                this.mPropertiesPanel.add((Component)new JLabel("(Required)"), gridBagConstraints);
            }
            this.mPropertyFields[n2] = jComponent;
            ++n2;
        }
        super.add(this.mPropertiesPanel);
    }

    public boolean updateProperties() {
        int n = this.mEntries.length;
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            PropertyEntry propertyEntry = this.mEntries[n2];
            String string = propertyEntry.getType();
            JComponent jComponent = this.mPropertyFields[n2];
            String string2 = string.equals("boolean") ? (((JCheckBox)jComponent).isSelected() ? "true" : "false") : (string.equals("yesno") ? (((JCheckBox)jComponent).isSelected() ? "yes" : "no") : ((JTextField)jComponent).getText());
            if (string2 == null) {
                string2 = "";
            }
            boolean bl = true;
            if (!propertyEntry.isOptional() || !string2.equals("")) {
                if (string2.length() == 0) {
                    bl = false;
                } else if (string.equals("string")) {
                    bl = true;
                } else if (string.equals("integer")) {
                    bl = StringValidator.isInteger(string2);
                } else if (string.equals("float")) {
                    bl = StringValidator.isFloat(string2);
                } else if (string.equals("class name")) {
                    bl = StringValidator.isClass(string2);
                } else if (string.equals("URI")) {
                    bl = StringValidator.isURI(string2);
                } else if (string.equals("relative path")) {
                    bl = StringValidator.isRelativePath(string2);
                } else if (string.equals("word")) {
                    bl = StringValidator.isToken(string2);
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(null, propertyEntry.getSummary() + " should be a " + string, "Data Error!", 0);
                return false;
            }
            this.mProperties.setProperty(propertyEntry.getName(), string2);
            ++n2;
        }
        return true;
    }
}

