/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import uk.org.ogsadai.tools.general.Categories;
import uk.org.ogsadai.tools.general.Category;

public class JCategoriesPanel
extends JPanel {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private TitledBorder mTitleBorder;
    private Categories[] mCategories = null;
    private JPanel mCategoriesPanel = new JPanel();
    private ButtonGroup mButtonGroup = new ButtonGroup();

    public JCategoriesPanel(Categories[] categoriesArray) {
        this.mTitleBorder = BorderFactory.createTitledBorder("");
        super.setBorder(this.mTitleBorder);
        super.setLayout(new BorderLayout());
        if (categoriesArray == null) {
            throw new IllegalArgumentException();
        }
        this.mCategories = categoriesArray;
        this.refresh();
    }

    public void setTitle(String string) {
        this.mTitleBorder.setTitle(string);
        this.repaint();
    }

    public void refresh() {
        if (this.mCategoriesPanel != null) {
            super.remove(this.mCategoriesPanel);
        }
        this.mButtonGroup = new ButtonGroup();
        this.mCategoriesPanel = new JPanel();
        this.mCategoriesPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        int n = this.mCategories.length;
        int n2 = 0;
        while (n2 < n) {
            Categories categories = this.mCategories[n2];
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createTitledBorder(categories.getName()));
            this.mCategoriesPanel.add((Component)box, gridBagConstraints);
            int n3 = categories.getNumCategories();
            int n4 = 0;
            while (n4 < n3) {
                Category category = categories.getCategory(n4);
                JRadioButton jRadioButton = new JRadioButton(category.getName());
                jRadioButton.setActionCommand(n2 + "," + n4);
                box.add(jRadioButton);
                this.mButtonGroup.add(jRadioButton);
                ++n4;
            }
            ++n2;
        }
        super.add(this.mCategoriesPanel);
    }

    public int getCategory() {
        ButtonModel buttonModel = this.mButtonGroup.getSelection();
        if (buttonModel == null) {
            return -1;
        }
        String string = buttonModel.getActionCommand();
        String string2 = string.substring(0, string.indexOf(44));
        try {
            return new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getSubCategory() {
        ButtonModel buttonModel = this.mButtonGroup.getSelection();
        if (buttonModel == null) {
            return -1;
        }
        String string = buttonModel.getActionCommand();
        String string2 = string.substring(string.indexOf(44) + 1, string.length());
        try {
            return new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

