/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tools.general;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.PatternSyntaxException;

public class StringValidator {
    private static String COPYRIGHT_NOTICE = "(c) International Business Machines Corporation 2002-2005, (c) University of Edinburgh 2002-2005";
    private static final String PACKAGE_CLASS_REGEXP = "([a-zA-Z0-9_]+\\.)*([a-zA-Z][a-zA-Z0-9_]*)";
    private static final String RELATIVE_PATH_REGEXP = "([a-zA-Z0-9_]+\\/)+([a-zA-Z][a-zA-Z0-9_]*)";
    private static final String Y = "y";
    private static final String N = "n";

    public static boolean isRelativePath(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else {
            try {
                bl = string.matches(RELATIVE_PATH_REGEXP);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isClass(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else {
            try {
                bl = string.matches(PACKAGE_CLASS_REGEXP);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isToken(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else {
            try {
                bl = string.matches("^\\S*$");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isFloat(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else {
            try {
                Float f = new Float(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isInteger(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else {
            try {
                Integer n = new Integer(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isURI(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else {
            try {
                URI uRI = new URI(string);
                bl = true;
            }
            catch (URISyntaxException uRISyntaxException) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isYN(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = string.substring(0, 1).toLowerCase();
        return Y.equals(string2) || N.equals(string2);
    }
}

