/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.tools.wsdl;

import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.tools.CommandLineTool;
import org.globus.wsrf.tools.wsdl.RelativePathUtil;

public class GenerateBinding {
    private static String ADDRESS = "localhost:8080/wsrf/services/";
    private static String PROTOCOL = "http";
    public static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String HTTP_NS = "http://schemas.xmlsoap.org/soap/http";
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$tools$wsdl$GenerateBinding == null ? (class$org$globus$wsrf$tools$wsdl$GenerateBinding = GenerateBinding.class$("org.globus.wsrf.tools.wsdl.GenerateBinding")) : class$org$globus$wsrf$tools$wsdl$GenerateBinding).getName());
    static /* synthetic */ Class class$org$globus$wsrf$tools$wsdl$GenerateBinding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Definition portTypeDefinition = null;
        CommandLine commandLine = null;
        Options options = new Options();
        Option option = null;
        HelpFormatter formatter = new HelpFormatter();
        String portTypeFile = null;
        String fileRoot = null;
        Definition bindingDefinition = null;
        Definition serviceDefinition = null;
        option = new Option("o", "out", true, "Specifies the filename prefix for the generated bindings files");
        option.setArgName("PREFIX");
        option.setRequired(true);
        options.addOption(option);
        option = new Option("p", "protocol", true, "Specifies the protocol to bind to (default: http)");
        option.setArgName("PROTOCOL");
        options.addOption(option);
        option = new Option("i", "in", true, "Specifies the file containing the porttype to process");
        option.setArgName("FILE");
        option.setRequired(true);
        options.addOption(option);
        options.addOption("h", "help", false, "Prints this help message");
        GnuParser parser = new GnuParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            formatter.printHelp((class$org$globus$wsrf$tools$wsdl$GenerateBinding == null ? (class$org$globus$wsrf$tools$wsdl$GenerateBinding = GenerateBinding.class$("org.globus.wsrf.tools.wsdl.GenerateBinding")) : class$org$globus$wsrf$tools$wsdl$GenerateBinding).getName(), options, true);
            CommandLineTool.sysExit(1);
        }
        if (commandLine.hasOption('h')) {
            formatter.printHelp((class$org$globus$wsrf$tools$wsdl$GenerateBinding == null ? (class$org$globus$wsrf$tools$wsdl$GenerateBinding = GenerateBinding.class$("org.globus.wsrf.tools.wsdl.GenerateBinding")) : class$org$globus$wsrf$tools$wsdl$GenerateBinding).getName(), options, true);
        }
        if (commandLine.hasOption('p')) {
            PROTOCOL = commandLine.getOptionValue('p');
        }
        portTypeFile = commandLine.getOptionValue('i');
        fileRoot = commandLine.getOptionValue('o');
        args = commandLine.getArgs();
        if (args.length != 0) {
            formatter.printHelp((class$org$globus$wsrf$tools$wsdl$GenerateBinding == null ? (class$org$globus$wsrf$tools$wsdl$GenerateBinding = GenerateBinding.class$("org.globus.wsrf.tools.wsdl.GenerateBinding")) : class$org$globus$wsrf$tools$wsdl$GenerateBinding).getName(), options, false);
            CommandLineTool.sysExit(1);
        }
        FileOutputStream bindingDefintionOutput = null;
        FileOutputStream serviceDefinitionOutput = null;
        FileInputStream portTypeInput = null;
        portTypeFile = new File(portTypeFile).getCanonicalPath();
        portTypeInput = new FileInputStream(portTypeFile);
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        WSDLWriter writer = factory.newWSDLWriter();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        portTypeDefinition = reader.readWSDL(null, portTypeFile);
        bindingDefinition = factory.newDefinition();
        serviceDefinition = factory.newDefinition();
        if (portTypeDefinition.getQName() == null) {
            System.err.println("Missing 'name' attribute in 'definitions' element.");
            CommandLineTool.sysExit(1);
        }
        bindingDefinition.setQName(new QName(portTypeDefinition.getQName().getLocalPart()));
        serviceDefinition.setQName(new QName(portTypeDefinition.getQName().getLocalPart()));
        bindingDefinition.setTargetNamespace(portTypeDefinition.getTargetNamespace() + "/bindings");
        bindingDefinition.setExtensionRegistry((ExtensionRegistry)new PopulatedExtensionRegistry());
        bindingDefinition.addNamespace("soap", SOAP_NS);
        bindingDefinition.addNamespace("porttype", portTypeDefinition.getTargetNamespace());
        String bindingFile = fileRoot + "_bindings.wsdl";
        bindingFile = new File(bindingFile).getCanonicalPath();
        bindingDefintionOutput = new FileOutputStream(bindingFile);
        String relativePortTypeFile = RelativePathUtil.getRelativeFileName(new File(portTypeFile), new File(bindingFile));
        Import portTypeImport = bindingDefinition.createImport();
        portTypeImport.setLocationURI(relativePortTypeFile);
        portTypeImport.setNamespaceURI(portTypeDefinition.getTargetNamespace());
        bindingDefinition.addImport(portTypeImport);
        serviceDefinition.setTargetNamespace(portTypeDefinition.getTargetNamespace() + "/service");
        serviceDefinition.setExtensionRegistry((ExtensionRegistry)new PopulatedExtensionRegistry());
        serviceDefinition.addNamespace("soap", SOAP_NS);
        serviceDefinition.addNamespace("binding", bindingDefinition.getTargetNamespace());
        String serviceFile = fileRoot + "_service.wsdl";
        serviceFile = new File(serviceFile).getCanonicalPath();
        serviceDefinitionOutput = new FileOutputStream(serviceFile);
        String relativeBindingFile = RelativePathUtil.getRelativeFileName(new File(bindingFile), new File(serviceFile));
        Import bindingImport = serviceDefinition.createImport();
        bindingImport.setLocationURI(relativeBindingFile);
        bindingImport.setNamespaceURI(bindingDefinition.getTargetNamespace());
        serviceDefinition.addImport(bindingImport);
        Service service = serviceDefinition.createService();
        if (serviceDefinition.getQName().getLocalPart().endsWith("Service")) {
            service.setQName(serviceDefinition.getQName());
        } else {
            service.setQName(new QName(serviceDefinition.getQName().getLocalPart() + "Service"));
        }
        Iterator portTypeIterator = portTypeDefinition.getPortTypes().values().iterator();
        while (portTypeIterator.hasNext()) {
            PortType portType = (PortType)portTypeIterator.next();
            Binding binding = GenerateBinding.processPortType(bindingDefinition, portType);
            bindingDefinition.addBinding(binding);
            service.addPort(GenerateBinding.createPort(serviceDefinition, portType, binding));
        }
        writer.writeWSDL(bindingDefinition, (OutputStream)bindingDefintionOutput);
        serviceDefinition.addService(service);
        writer.writeWSDL(serviceDefinition, (OutputStream)serviceDefinitionOutput);
        Object var28_29 = null;
        if (portTypeInput == null) return;
        try {
            portTypeInput.close();
            return;
        }
        catch (Exception io) {}
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                CommandLineTool.sysExit(1);
                Object var28_30 = null;
                if (portTypeInput == null) return;
                try {
                    portTypeInput.close();
                    return;
                }
                catch (Exception io) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var28_31 = null;
            if (portTypeInput == null) throw throwable;
            try {
                portTypeInput.close();
                throw throwable;
            }
            catch (Exception io) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static Port createPort(Definition serviceDefinition, PortType portType, Binding binding) {
        Port port = serviceDefinition.createPort();
        port.setName(portType.getQName().getLocalPart() + "Port");
        port.setBinding(binding);
        SOAPAddressImpl soapAddress = new SOAPAddressImpl();
        soapAddress.setLocationURI(PROTOCOL + "://" + ADDRESS);
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        return port;
    }

    private static Binding processPortType(Definition bindingDefinition, PortType portType) {
        Binding binding = bindingDefinition.createBinding();
        binding.setPortType(portType);
        binding.setUndefined(false);
        binding.setQName(new QName(bindingDefinition.getTargetNamespace(), portType.getQName().getLocalPart() + "SOAPBinding"));
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setTransportURI(HTTP_NS);
        soapBinding.setStyle("document");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        Iterator operationIterator = portType.getOperations().iterator();
        while (operationIterator.hasNext()) {
            try {
                BindingOperation bindingOperation = GenerateBinding.processOperation(bindingDefinition, portType.getQName(), (Operation)operationIterator.next());
                binding.addBindingOperation(bindingOperation);
            }
            catch (Exception e) {
                System.err.println("Failed to add operation to binding");
                e.printStackTrace();
                CommandLineTool.sysExit(1);
            }
        }
        return binding;
    }

    private static BindingOperation processOperation(Definition bindingDefinition, QName portTypeQName, Operation operation) throws Exception {
        BindingOperation bindingOperation = bindingDefinition.createBindingOperation();
        bindingOperation.setOperation(operation);
        bindingOperation.setName(operation.getName());
        Input input = operation.getInput();
        if (input == null) {
            throw new Exception("Operation is lacking a <input> element");
        }
        Message inputMessage = input.getMessage();
        if (inputMessage == null) {
            throw new Exception("Input is lacking a <message> element");
        }
        List inputParts = inputMessage.getOrderedParts(null);
        if (inputParts == null || inputParts.isEmpty()) {
            throw new Exception("No <part> element for input message: " + inputMessage.getQName());
        }
        SOAPOperationImpl soapOperation = new SOAPOperationImpl();
        String action = AddressingUtils.getInputAction((QName)portTypeQName, (Operation)operation);
        soapOperation.setSoapActionURI(action);
        bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
        BindingInput bindingInput = bindingDefinition.createBindingInput();
        SOAPBodyImpl soapBody = new SOAPBodyImpl();
        soapBody.setUse("literal");
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
        bindingOperation.setBindingInput(bindingInput);
        if (operation.getOutput() != null) {
            BindingOutput bindingOutput = bindingDefinition.createBindingOutput();
            soapBody = new SOAPBodyImpl();
            soapBody.setUse("literal");
            bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
            bindingOperation.setBindingOutput(bindingOutput);
        }
        Iterator faulIterator = operation.getFaults().values().iterator();
        while (faulIterator.hasNext()) {
            BindingFault bindingFault = GenerateBinding.processFault((Fault)faulIterator.next(), bindingDefinition);
            bindingOperation.addBindingFault(bindingFault);
        }
        return bindingOperation;
    }

    private static BindingFault processFault(Fault fault, Definition bindingDefinition) {
        SOAPFaultImpl soapFault = new SOAPFaultImpl();
        soapFault.setName(fault.getName());
        soapFault.setUse("literal");
        BindingFault bindingFault = bindingDefinition.createBindingFault();
        bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
        bindingFault.setName(fault.getName());
        return bindingFault;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

