/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.tools.jndi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.tools.CommandLineTool;
import org.globus.wsrf.tools.jndi.ConfigContext;
import org.globus.wsrf.tools.jndi.JNDIConfigRuleSet;

public class JNDIConfigTool
extends CommandLineTool {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$tools$jndi$JNDIConfigTool == null ? (class$org$globus$wsrf$tools$jndi$JNDIConfigTool = JNDIConfigTool.class$("org.globus.wsrf.tools.jndi.JNDIConfigTool")) : class$org$globus$wsrf$tools$jndi$JNDIConfigTool).getName());
    static /* synthetic */ Class class$org$globus$wsrf$tools$jndi$JNDIConfigTool;

    public static void main(String[] args) {
        String msg;
        boolean quiet = false;
        boolean overwrite = false;
        File configFile = null;
        FileInputStream configInput = null;
        Digester digester = null;
        ConfigContext inContext = null;
        CommandLine commandLine = null;
        Options options = new Options();
        Option option = null;
        HelpFormatter formatter = new HelpFormatter();
        option = new Option("a", "add", true, "Add the contents of the specified file");
        option.setArgName("FILE");
        options.addOption(option);
        option = new Option("r", "remove", true, "Remove the entry for the given service name");
        option.setArgName("SERVICENAME");
        options.addOption(option);
        option = new Option("f", "file", true, "Specifies the JNDI configuration file");
        option.setArgName("FILE");
        option.setRequired(true);
        options.addOption(option);
        options.addOption("h", "help", false, "Prints this help message");
        options.addOption("q", "quiet", false, "Don't print warnings");
        options.addOption("o", "overwrite", false, "Overwrite sections");
        GnuParser parser = new GnuParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            formatter.printHelp((class$org$globus$wsrf$tools$jndi$JNDIConfigTool == null ? (class$org$globus$wsrf$tools$jndi$JNDIConfigTool = JNDIConfigTool.class$("org.globus.wsrf.tools.jndi.JNDIConfigTool")) : class$org$globus$wsrf$tools$jndi$JNDIConfigTool).getName(), options, true);
            JNDIConfigTool.sysExit(1);
        }
        args = commandLine.getArgs();
        if (args.length != 0) {
            formatter.printHelp((class$org$globus$wsrf$tools$jndi$JNDIConfigTool == null ? (class$org$globus$wsrf$tools$jndi$JNDIConfigTool = JNDIConfigTool.class$("org.globus.wsrf.tools.jndi.JNDIConfigTool")) : class$org$globus$wsrf$tools$jndi$JNDIConfigTool).getName(), options, false);
            JNDIConfigTool.sysExit(1);
        }
        if (commandLine.hasOption('h')) {
            formatter.printHelp((class$org$globus$wsrf$tools$jndi$JNDIConfigTool == null ? (class$org$globus$wsrf$tools$jndi$JNDIConfigTool = JNDIConfigTool.class$("org.globus.wsrf.tools.jndi.JNDIConfigTool")) : class$org$globus$wsrf$tools$jndi$JNDIConfigTool).getName(), options, true);
            JNDIConfigTool.sysExit(0);
        }
        if (commandLine.hasOption('q')) {
            quiet = true;
        }
        if (commandLine.hasOption('o')) {
            overwrite = true;
        }
        try {
            configFile = new File(commandLine.getOptionValue('f')).getCanonicalFile();
        }
        catch (Exception e) {
            msg = "ERROR: Failed to get canonical file name for configuration file";
            logger.error((Object)msg, (Throwable)e);
            System.err.println(msg);
            JNDIConfigTool.sysExit(1);
        }
        try {
            configInput = new FileInputStream(configFile);
        }
        catch (FileNotFoundException e) {
            if (commandLine.hasOption('a')) {
                configInput = null;
            }
            msg = "ERROR: Failed to open configuration file.";
            logger.error((Object)msg, (Throwable)e);
            System.err.println(msg);
            JNDIConfigTool.sysExit(1);
        }
        if (configInput != null) {
            digester = new Digester();
            digester.setNamespaceAware(true);
            digester.setValidating(false);
            digester.addRuleSet((RuleSet)new JNDIConfigRuleSet("jndiConfig/"));
            inContext = new ConfigContext(true);
            digester.push((Object)inContext);
            try {
                digester.parse((InputStream)configInput);
                digester.clear();
            }
            catch (Exception e) {
                msg = "ERROR: Failed to parse configuration file.";
                logger.error((Object)msg, (Throwable)e);
                System.err.println(msg);
                JNDIConfigTool.sysExit(1);
            }
        }
        if (commandLine.hasOption('a')) {
            String msg2;
            File addFile = null;
            try {
                addFile = new File(commandLine.getOptionValue('a')).getCanonicalFile();
            }
            catch (Exception e) {
                msg2 = "ERROR: Failed to get canonical file name for additions file";
                logger.error((Object)msg2, (Throwable)e);
                System.err.println(msg2);
                JNDIConfigTool.sysExit(1);
            }
            if (configInput == null) {
                try {
                    JNDIConfigTool.copy(addFile, configFile);
                }
                catch (Exception e) {
                    msg2 = "ERROR: Failed to copy additions file to configuration file.";
                    logger.error((Object)msg2, (Throwable)e);
                    System.err.println(msg2);
                    JNDIConfigTool.sysExit(1);
                }
                JNDIConfigTool.sysExit(0);
            } else {
                String msg3;
                FileInputStream addInput = null;
                ConfigContext addContext = null;
                try {
                    addInput = new FileInputStream(addFile);
                }
                catch (FileNotFoundException e) {
                    msg3 = "ERROR: Failed to open additions file.";
                    logger.error((Object)msg3, (Throwable)e);
                    System.err.println(msg3);
                    JNDIConfigTool.sysExit(1);
                }
                addContext = new ConfigContext(true);
                digester.push((Object)addContext);
                try {
                    digester.parse((InputStream)addInput);
                    digester.clear();
                }
                catch (Exception e) {
                    msg3 = "ERROR: Failed to parse additions file.";
                    logger.error((Object)msg3, (Throwable)e);
                    System.err.println(msg3);
                    JNDIConfigTool.sysExit(1);
                }
                try {
                    JNDIConfigTool.merge(inContext, addContext, null, null, overwrite);
                }
                catch (Exception e) {
                    msg3 = "ERROR: Failed to merge additions file.";
                    logger.error((Object)msg3, (Throwable)e);
                    System.err.println(msg3);
                    JNDIConfigTool.sysExit(1);
                }
            }
        }
        if (commandLine.hasOption('r')) {
            String serviceName = commandLine.getOptionValue('r');
            inContext.removeSubContext(serviceName);
        }
        try {
            FileOutputStream configOutput = new FileOutputStream(configFile);
            PrintWriter configWriter = new PrintWriter(configOutput);
            configWriter.write(inContext.toString());
            configWriter.close();
        }
        catch (Exception e) {
            msg = "ERROR: Failed to write processed configuration file.";
            logger.error((Object)msg, (Throwable)e);
            System.err.println(msg);
            JNDIConfigTool.sysExit(1);
        }
        JNDIConfigTool.sysExit(0);
    }

    private static void copy(File inFile, File outFile) throws IOException, FileNotFoundException {
        int b;
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outFile));
        while ((b = inStream.read()) != -1) {
            outStream.write(b);
        }
        inStream.close();
        outStream.close();
    }

    private static void merge(ConfigContext targetContext, ConfigContext inContext, String section, String serviceName, boolean overwrite) throws Exception {
        String name;
        Set names = null;
        Iterator nameIterator = null;
        ConfigContext serviceContext = null;
        ConfigContext targetServiceContext = null;
        if (section == null || section.equals("service")) {
            if (serviceName != null) {
                if (inContext.getSubContext(serviceName) == null) {
                    throw new Exception("Couldn't find service node with name: " + serviceName);
                }
                names = new HashSet<String>();
                names.add(serviceName);
            } else {
                names = inContext.getSubContextNames();
            }
            nameIterator = names.iterator();
            while (nameIterator.hasNext()) {
                name = (String)nameIterator.next();
                serviceContext = inContext.getSubContext(name);
                if (overwrite || (targetServiceContext = targetContext.getSubContext(name)) == null) {
                    targetContext.addSubContext(serviceContext);
                    continue;
                }
                JNDIConfigTool.mergeContexts(serviceContext, targetServiceContext);
            }
        }
        if (section == null || section.equals("global")) {
            if (overwrite) {
                names = targetContext.getSubContextNames();
                nameIterator = names.iterator();
                while (nameIterator.hasNext()) {
                    name = (String)nameIterator.next();
                    if (inContext.getSubContext(name) != null) continue;
                    inContext.addSubContext(targetContext.getSubContext(name));
                }
            } else {
                JNDIConfigTool.mergeContexts(inContext, targetContext);
            }
        }
    }

    private static void mergeContexts(ConfigContext inContext, ConfigContext targetContext) {
        Set names = null;
        Iterator nameIterator = null;
        names = inContext.getEnvironmentNames();
        nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            targetContext.addEnvironment(inContext.getEnvironment((String)nameIterator.next()));
        }
        names = inContext.getResourceNames();
        nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            targetContext.addResource(inContext.getResource((String)nameIterator.next()));
        }
        names = inContext.getResourceLinkNames();
        nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            targetContext.addResourceLink(inContext.getResourceLink((String)nameIterator.next()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

