/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport.commons;

import java.net.URL;
import org.apache.axis.MessageContext;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.transport.http.CommonsHTTPSender;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.globus.axis.transport.commons.CommonsHttpConnectionManager;
import org.globus.axis.transport.commons.CommonsSSLSocketFactory;

public class HTTPSSender
extends CommonsHTTPSender {
    protected static final String[] PARAMS = new String[]{"org.globus.gsi.authorization", "org.globus.gsi.anonymous", "org.globus.gsi.credentials", "org.globus.security.transport.type"};
    private static CommonsHttpConnectionManager globalConnectionManager;
    private static CommonsHTTPClientProperties globalClientProperties;

    protected void initialize() {
        this.clientProperties = globalClientProperties;
        this.connectionManager = globalConnectionManager;
    }

    protected HostConfiguration getHostConfiguration(HttpClient client, MessageContext context, URL targetURL) {
        HostConfiguration config = super.getHostConfiguration(client, context, targetURL);
        Boolean prop = (Boolean)context.getProperty("transport.http.disableChunking");
        if (prop != null) {
            client.getParams().setParameter("transport.http.disableChunking", (Object)prop);
        }
        for (int i = 0; i < PARAMS.length; ++i) {
            Object value = context.getProperty(PARAMS[i]);
            if (value == null) continue;
            config.getParams().setParameter(PARAMS[i], value);
        }
        return config;
    }

    static {
        Protocol protocol = new Protocol("https", (ProtocolSocketFactory)new CommonsSSLSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)protocol);
        globalConnectionManager = new CommonsHttpConnectionManager(PARAMS);
        globalClientProperties = CommonsHTTPClientPropertiesFactory.create();
        CommonsHttpConnectionManager.setStaleCheckingEnabled(globalConnectionManager);
        CommonsHttpConnectionManager.setConnectionIdleTime(globalConnectionManager);
    }
}

