/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.demoTransientFactory;

import java.io.File;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.examples.demoTransientFactory.ChildDataServiceResourceComponentProvider;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.service.resource.config.FileBasedActivitiesConfig;
import uk.org.ogsadai.sessions.SessionComponentFactory;
import uk.org.ogsadai.sessions.SessionConfigurationLoader;

public class DemoTransientFactoryDataResourceAccessor
implements DataResourceAccessor,
PersistInFiles,
ChildDataServiceResourceComponentProvider {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    String mResourceName;
    ActivitiesConfig mChildActivitiesConfig;
    SessionComponentFactory mSessionComponentFactory;

    public void setResourceName(String resourceName) {
        this.mResourceName = resourceName;
    }

    public void restoreFromConfig(File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        File instanceDirectory = new File(directory, "instance");
        try {
            File childActivityConfigFile = new File(instanceDirectory, "activityConfig.xml");
            this.mChildActivitiesConfig = new FileBasedActivitiesConfig(childActivityConfigFile);
            File childSessionConfigFile = new File(instanceDirectory, "sessionConfig.xml");
            this.mSessionComponentFactory = new SessionConfigurationLoader(childSessionConfigFile);
        }
        catch (DAIException e) {
            throw new DataResourceAccessorConfigException(this.mResourceName, (Exception)((Object)e));
        }
    }

    public Property[] getProperties() {
        return new Property[0];
    }

    public ActivitiesConfig getChildActivitiesConfig() {
        return this.mChildActivitiesConfig;
    }

    public SessionComponentFactory getChildSessionComponentFactory() {
        return this.mSessionComponentFactory;
    }
}

