/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.demoFactory;

import java.io.File;
import javax.xml.namespace.QName;
import uk.org.ogsadai.common.files.DAIFileNotFileException;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyValueException;
import uk.org.ogsadai.common.properties.StaticProperty;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.examples.demoFactory.DemoNameProvider;

public class DemoInstanceDataResourceAccessor
implements DataResourceAccessor,
PersistInFiles,
DemoNameProvider {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private String mResourceName;
    private String mName;
    public static final QName NAME_PROPERTY_QNAME = new QName("http://ogsadai.org.uk/namespaces/2005/10/properties", "name");

    public void setResourceName(String resourceName) {
        this.mResourceName = resourceName;
    }

    public void restoreFromConfig(File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        File nameFile = new File(directory, "name.txt");
        try {
            this.mName = FileUtilities.readStringFromFile((String)nameFile.getAbsolutePath());
        }
        catch (DAIFileNotFoundException e) {
            throw new DataResourceAccessorConfigException(this.mResourceName, (Exception)((Object)e));
        }
        catch (DAIFileNotFileException e) {
            throw new DataResourceAccessorConfigException(this.mResourceName, (Exception)((Object)e));
        }
        catch (DAIFileReadIOException e) {
            throw new DataResourceAccessorConfigException(this.mResourceName, (Exception)((Object)e));
        }
    }

    public Property[] getProperties() {
        StaticProperty prop = new StaticProperty();
        prop.setName(NAME_PROPERTY_QNAME);
        try {
            prop.setValue((Object)this.mName);
        }
        catch (PropertyValueException propertyValueException) {
            // empty catch block
        }
        return new Property[]{prop};
    }

    public String getName() {
        return this.mName;
    }
}

