/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.demoFactory;

import java.io.File;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.service.resource.factory.ConfigDirectoryProvider;
import uk.org.ogsadai.service.resource.factory.DataServiceResourceFactory;

public class DemoCreateInstanceActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final String INSTANCE_CLASS_NAME = "uk.org.ogsadai.examples.demoFactory.DemoInstanceDataResourceAccessor";
    private BlockWriter mOutput;
    private String mName;

    public DemoCreateInstanceActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "myOutput").item(0)).getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        Element configuration = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "name").item(0);
        this.mName = configuration.getAttribute("value");
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        DataServiceResourceFactory factory = this.mContext.getDataResourceFactory();
        String resourceName = factory.getNewResourceName();
        try {
            File configDir = factory.getResourceConfigDirectory(resourceName);
            ConfigDirectoryProvider configDirProv = (ConfigDirectoryProvider)this.mContext.getDataResourceAccessor();
            File sourceDir = new File(configDirProv.getConfigDirectory(), "instance");
            FileUtilities.copyDirectoryContents((File)sourceDir, (File)configDir);
            File nameFile = new File(configDir, "name.txt");
            FileUtilities.replaceWriteStringToFile((String)nameFile.getAbsolutePath(), (String)this.mName);
            factory.createResource(resourceName, INSTANCE_CLASS_NAME);
            this.mOutput.put((Object)resourceName);
            this.setCompleted();
        }
        catch (Exception e) {
            ActivitySpecificationException error = new ActivitySpecificationException(this.getName(), (Throwable)e);
            this.setError((Throwable)error);
        }
    }
}

