/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.dataResourceAccessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import javax.xml.namespace.QName;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.StaticProperty;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.examples.dataResourceAccessor.TemperatureProvider;

public class TemperatureDataResourceAccessor
implements DataResourceAccessor,
PersistInFiles,
TemperatureProvider {
    private static final String COPYRIGHT_NOTICE = "The University of Edinburgh 2002 - 2005.";
    private String mResourceName;
    private float minValue;
    private float maxValue;
    private StaticProperty minValueProp;
    private StaticProperty maxValueProp;
    private Random rand = new Random();

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName must not be null");
        }
        this.mResourceName = resourceName;
    }

    public void restoreFromConfig(File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        File rangeFile = new File(directory, "range.txt");
        try {
            BufferedReader in = new BufferedReader(new FileReader(rangeFile));
            String line = in.readLine();
            this.minValue = Float.parseFloat(line);
            line = in.readLine();
            this.maxValue = Float.parseFloat(line);
        }
        catch (FileNotFoundException e) {
            throw new DataResourceAccessorConfigException(this.mResourceName, (Exception)new DAIFileNotFoundException(rangeFile));
        }
        catch (IOException e) {
            throw new DataResourceAccessorConfigException(this.mResourceName, (Exception)new DAIFileReadIOException(rangeFile, e));
        }
        QName minValueQName = new QName("http://ogsadai.org.uk/demoNamespace", "minValue");
        this.minValueProp = new StaticProperty();
        this.minValueProp.setName(minValueQName);
        this.minValueProp.setValue((Object)("" + this.minValue));
        QName maxValueQName = new QName("http://ogsadai.org.uk/demoNamespace", "maxValue");
        this.maxValueProp = new StaticProperty();
        this.maxValueProp.setName(maxValueQName);
        this.maxValueProp.setValue((Object)("" + this.maxValue));
    }

    public Property[] getProperties() {
        return new Property[]{this.minValueProp, this.maxValueProp};
    }

    public synchronized float getTemperature() {
        return this.rand.nextFloat() * (this.maxValue - this.minValue) + this.minValue;
    }
}

