/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XPathQuery;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XUpdate;
import uk.org.ogsadai.client.toolkit.service.DataService;

public class XUpdateExample {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";

    public static void main(String[] args) throws Exception {
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "ExistResource";
        if (args.length == 1) {
            handle = args[0];
        }
        DataService service = GenericServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());
        String xupdate = "<xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\"><xu:update select=\"/entry[@id=99]/name\">Harold Bishop</xu:update></xu:modifications>";
        XUpdate update = new XUpdate(xupdate);
        System.out.println("Performing update...");
        service.perform((RequestComponent)update);
        ActivityOutput results = update.getOutput();
        System.out.println("Results:\n" + results.getData());
        XPathQuery query = new XPathQuery("/entry[@id=99]");
        service.perform((RequestComponent)query);
        results = query.getOutput();
        System.out.println("Modified entry:\n" + results.getData());
        xupdate = "<xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\"><xu:update select=\"/entry[@id=99]/name\">Paul Krause</xu:update></xu:modifications>";
        update = new XUpdate(xupdate);
        System.out.println("Undoing update...");
        service.perform((RequestComponent)update);
        results = update.getOutput();
        System.out.println("Results:\n" + results.getData());
        query = new XPathQuery("/entry[@id=99]");
        service.perform((RequestComponent)query);
        results = query.getOutput();
        System.out.println("Modified entry:\n" + results.getData());
    }
}

