/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.delivery.DeliverFromURL;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.activity.transform.XSLTransform;
import uk.org.ogsadai.client.toolkit.service.DataService;

public class XSLTransformWithDelivery {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";

    public static void main(String[] args) throws Exception {
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        if (args.length == 1) {
            handle = args[0];
        }
        DataService service = GenericServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());
        String url = "http://localhost:8080/tutorial/transformRowSet.xsl";
        DeliverFromURL deliver = new DeliverFromURL(url);
        SQLQuery query = new SQLQuery("select * from littleblackbook where id<=1000");
        WebRowSet rowset = new WebRowSet(query.getOutput());
        XSLTransform transform = new XSLTransform();
        transform.setXMLInput(rowset.getOutput());
        transform.setXSLTInput(deliver.getOutput());
        ActivityRequest request = new ActivityRequest();
        request.add((RequestComponent)deliver);
        request.add((RequestComponent)query);
        request.add((RequestComponent)rowset);
        request.add((RequestComponent)transform);
        System.out.println("Performing request...");
        service.perform((Request)request);
        System.out.println("Results:\n" + transform.getOutput().getData());
    }
}

