/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.CoGUtil;
import uk.org.ogsadai.client.toolkit.ConnectionProperty;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSITransportEncryptionProperty;
import uk.org.ogsadai.client.toolkit.service.DataService;

public class WSRFTransportLevelSecurityExample {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006.";

    public static void main(String[] args) throws Exception {
        if (!CoGUtil.isRegistered()) {
            System.out.println(CoGUtil.getRegistrationException().getLocalizedMessage());
            return;
        }
        String handle = "https://myComputer.MyCompany.com:8443/wsrf/services/ogsadai/SecureDataService";
        String id = "MySQLResource";
        if (args.length == 1) {
            handle = args[0];
        }
        DataService secureService = GenericServiceFetcher.getInstance().getDataService(handle, id);
        secureService.setConnectionProperty((ConnectionProperty)new GSITransportEncryptionProperty());
        System.out.println("Ready to connect to secure data service at " + secureService.getURL());
        SQLQuery query = new SQLQuery("select * from littleblackbook where id='3475'");
        WebRowSet rowset = new WebRowSet(query.getOutput());
        ActivityRequest request = new ActivityRequest();
        request.add((RequestComponent)query);
        request.add((RequestComponent)rowset);
        System.out.println("Performing SQL query...");
        Response response = secureService.perform((Request)request);
        System.out.println("Response:\n" + response.getAsString());
    }

    static {
        CoGUtil.registerTransport();
    }
}

