/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import java.io.File;
import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.ConnectionProperty;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.security.wsrf.SecurityConfigProperty;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFDataService;

public class WSRFMessageLevelSecurityExample {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";

    public static void main(String[] args) throws Exception {
        String handle = "http://myComputer.myCompany.com:8999/wsrf/services/ogsadai/SecureDataService";
        String id = "MySQLResource";
        if (args.length == 1) {
            handle = args[0];
        }
        WSRFDataService secureService = GenericServiceFetcher.getInstance().getWSRFDataService(handle, id);
        SecurityConfigProperty securityProperty = new SecurityConfigProperty(new File("examples/src/uk/org/ogsadai/examples/clienttoolkit/MLSecurityDescriptor.xml"));
        secureService.setConnectionProperty((ConnectionProperty)securityProperty);
        System.out.println("Ready to connect to secure data service at " + secureService.getURL());
        SQLQuery query = new SQLQuery("select * from littleblackbook where id='3475'");
        WebRowSet rowset = new WebRowSet(query.getOutput());
        ActivityRequest request = new ActivityRequest();
        request.add((RequestComponent)query);
        request.add((RequestComponent)rowset);
        System.out.println("Performing SQL query...");
        secureService.perform((Request)request);
        ResultSet resultset = rowset.getResultSet();
        while (resultset.next()) {
            System.out.println("name = " + resultset.getString(2));
        }
    }
}

