/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.JoinExistingSession;
import uk.org.ogsadai.client.toolkit.sessions.JoinNewSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionRequirements;
import uk.org.ogsadai.client.toolkit.sessions.TerminateSession;

public class UsingSessionsExample {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private static final String SERVICE_HANDLE = "http://localhost:8080/wsrf/services/ogsadai/DataService";
    private static final String RESOURCE_NAME = "MySQLResource";

    public static void main(String[] args) throws Exception {
        DataService service = GenericServiceFetcher.getInstance().getDataService(SERVICE_HANDLE, RESOURCE_NAME);
        UsingSessionsExample.joinImplictSession(service);
        Session session = UsingSessionsExample.createNewSession(service);
        UsingSessionsExample.joinExistingSession(service, session);
        UsingSessionsExample.terminateSession(service, session);
    }

    private static void joinImplictSession(DataService service) throws Exception {
        ActivityRequest request = new ActivityRequest();
        request.add((RequestComponent)new SQLQuery("select * from littleblackbook where id<10"));
        Response response = service.perform((Request)request);
        Session session = response.getSession();
        System.out.println(session.getSessionID());
    }

    private static Session createNewSession(DataService service) throws Exception {
        ActivityRequest request = new ActivityRequest();
        JoinNewSession requirements = new JoinNewSession();
        request.setSessionRequirements((SessionRequirements)requirements);
        Response response = service.perform((Request)request);
        Session session = response.getSession();
        return session;
    }

    private static void joinExistingSession(DataService service, Session session) throws Exception {
        ActivityRequest request = new ActivityRequest();
        JoinExistingSession requirements = new JoinExistingSession(session);
        request.setSessionRequirements((SessionRequirements)requirements);
        SQLQuery query = new SQLQuery("select * from littleblackbook where id<10");
        WebRowSet webRowSet = new WebRowSet(query.getOutput());
        request.add((RequestComponent)query);
        request.add((RequestComponent)webRowSet);
        service.perform((Request)request);
    }

    private static void terminateSession(DataService service, Session session) throws Exception {
        ActivityRequest request = new ActivityRequest();
        TerminateSession requirements = new TerminateSession(session);
        request.setSessionRequirements((SessionRequirements)requirements);
        service.perform((Request)request);
    }
}

