/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLBulkLoad;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLUpdate;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.service.DataService;

public class SQLBulkLoadExample {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";

    public static void main(String[] args) throws Exception {
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        if (args.length == 1) {
            handle = args[0];
        }
        DataService service = GenericServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());
        String tableName = "mytable";
        String createTable = "create table if not exists " + tableName + " (id INTEGER, name VARCHAR(64), " + "address VARCHAR(128), phone VARCHAR(20))";
        SQLUpdate create = new SQLUpdate(createTable);
        System.out.println("Creating new table...");
        service.perform((RequestComponent)create);
        System.out.println("Result:\n" + create.getOutput().getData());
        SQLQuery query = new SQLQuery("select * from littleblackbook where name like '%Krause'");
        WebRowSet rowset = new WebRowSet(query.getOutput());
        SQLBulkLoad bulkLoad = new SQLBulkLoad(rowset.getOutput(), tableName);
        ActivityRequest request = new ActivityRequest();
        request.add((RequestComponent)query);
        request.add((RequestComponent)rowset);
        request.add((RequestComponent)bulkLoad);
        System.out.println("Peforming bulk load...");
        Response response = service.perform((Request)request);
        System.out.println("Response:\n" + response.getAsString());
        System.out.println("Querying new table...");
        query = new SQLQuery("select * from " + tableName);
        rowset = new WebRowSet(query.getOutput());
        request = new ActivityRequest();
        request.add((RequestComponent)query);
        request.add((RequestComponent)rowset);
        service.perform((Request)request);
        System.out.println("Contents of " + tableName + ":");
        System.out.println(rowset.getOutput().getData());
        String dropTable = "drop table " + tableName;
        SQLUpdate drop = new SQLUpdate(dropTable);
        System.out.println("Dropping table...");
        service.perform((RequestComponent)drop);
        System.out.println("Result:\n" + drop.getOutput().getData());
    }
}

