/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.delivery.DTOutputStream;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.JoinExistingSession;
import uk.org.ogsadai.client.toolkit.sessions.JoinNewSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionRequirements;
import uk.org.ogsadai.client.toolkit.sessions.TerminateSession;

public class ProcessingSQLQueryLargeResults {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";

    public static void main(String[] args) throws Exception {
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        if (args.length == 1) {
            handle = args[0];
        }
        DataService service = GenericServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());
        System.out.println("Creating a new session");
        ActivityRequest request = new ActivityRequest();
        request.setSessionRequirements((SessionRequirements)new JoinNewSession());
        Response response = service.perform((Request)request);
        Session session = response.getSession();
        String sql = "select * from littleblackbook";
        System.out.println("\nPerforming SQL query to return a large number of rows: " + sql);
        SQLQuery query = new SQLQuery(sql);
        WebRowSet rowset = new WebRowSet(query.getOutput());
        DTOutputStream deliver = new DTOutputStream(rowset.getOutput());
        request = new ActivityRequest();
        request.add((RequestComponent)query);
        request.add((RequestComponent)rowset);
        request.add((RequestComponent)deliver);
        request.setSessionRequirements((SessionRequirements)new JoinExistingSession(session));
        service.perform((Request)request);
        ResultSet result = deliver.getResultSet(100);
        result.next();
        int rowNumber = 1;
        String name = result.getString(2);
        String address = result.getString(3);
        String phone = result.getString(4);
        System.out.println("\nRow: " + rowNumber);
        System.out.println(name);
        System.out.println(address);
        System.out.println("phone: " + phone);
        System.out.println("\nNow printing out every thousandth row:\n");
        while (result.next()) {
            if (++rowNumber % 1000 != 0) continue;
            name = result.getString(2);
            address = result.getString(3);
            phone = result.getString(4);
            System.out.println("Row: " + rowNumber);
            System.out.println(name);
            System.out.println(address);
            System.out.println("phone: " + phone);
            System.out.println();
        }
        System.out.println("Received results, destroying session.");
        request = new ActivityRequest();
        request.setSessionRequirements((SessionRequirements)new TerminateSession(session));
        service.perform((Request)request);
    }
}

