/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.delivery.DTInputStream;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLUpdate;
import uk.org.ogsadai.client.toolkit.properties.RequestStatus;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.sessions.JoinExistingSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionID;
import uk.org.ogsadai.client.toolkit.sessions.SessionRequirements;
import uk.org.ogsadai.client.toolkit.sessions.SessionStreamID;

public class ParameterisedUpdateViaDataTransport {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006.";
    private static final String SERVICE_URL = "http://localhost:8080/wsrf/services/ogsadai/DataService";
    private static final String RESOURCE_NAME = "MySQLResource";

    public static void main(String[] args) throws Exception {
        GenericServiceFetcher fetcher = GenericServiceFetcher.getInstance();
        final DataService dataService = fetcher.getDataService(SERVICE_URL, RESOURCE_NAME);
        DTInputStream input = new DTInputStream();
        String sql = "insert into littleblackbook values (?,?,?,?)";
        SQLUpdate update = new SQLUpdate(sql);
        update.setParameter(1, input.getOutput());
        update.setParameter(2, input.getOutput());
        update.setParameter(3, input.getOutput());
        update.setParameter(4, input.getOutput());
        final ActivityRequest request = new ActivityRequest();
        request.add((RequestComponent)input);
        request.add((RequestComponent)update);
        System.out.println("Opening session");
        Session session = dataService.createSession();
        request.setSessionRequirements((SessionRequirements)new JoinExistingSession(session));
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Sending the request");
                    dataService.perform((Request)request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        ParameterisedUpdateViaDataTransport.pollDataService(dataService, session, RequestStatus.PROCESSING);
        SessionStreamID sessionStreamID = new SessionStreamID(session, input.getName());
        DataTransport dataTransport = dataService.createDataTransport(dataService.getResourceID(), sessionStreamID);
        System.out.println("Transporting data into the request");
        dataTransport.putBlock((Object)"10010");
        dataTransport.putBlock((Object)"Albert Einstein");
        dataTransport.putBlock((Object)"Patent Office, Bern");
        dataTransport.putBlock((Object)"0123456789");
        dataTransport.putBlock((Object)"10011");
        dataTransport.putBlock((Object)"Max Planck");
        dataTransport.putBlock((Object)"University of Berlin");
        dataTransport.putBlock((Object)"0123456789");
        dataTransport.putClosingBlock();
        System.out.println("Data transportation complete");
        System.out.println("Waiting for response");
        thread.join();
        System.out.println("Response received");
        System.out.println("Number of modified rows: " + update.getModifiedRowsCount());
        System.out.println("Closing session");
        dataService.closeSession(session);
        System.out.println("Done!");
    }

    private static void pollDataService(DataService dataService, Session session, RequestStatus state) throws Exception {
        SessionID id = session.getSessionID();
        while (!dataService.getStatus(id).equals(state)) {
            Thread.sleep(100L);
        }
    }
}

