/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.delivery.DTOutputStream;
import uk.org.ogsadai.client.toolkit.activity.delivery.DataTransportMode;
import uk.org.ogsadai.client.toolkit.activity.delivery.DeliverFromDT;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.JoinNewSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionRequirements;
import uk.org.ogsadai.client.toolkit.sessions.TerminateSession;

public class DataTransportExample {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";

    public static void main(String[] args) throws Exception {
        String sourceHandle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String sourceResource = "MySQLResource";
        String sinkHandle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String sinkResource = "MySQLResource";
        DataService sourceService = GenericServiceFetcher.getInstance().getDataService(sourceHandle, sourceResource);
        DataService sinkService = GenericServiceFetcher.getInstance().getDataService(sinkHandle, sinkResource);
        SQLQuery sqlQuery = new SQLQuery("select * from littleblackbook where id<100");
        WebRowSet rowset = new WebRowSet(sqlQuery.getOutput());
        DTOutputStream outputStream = new DTOutputStream();
        outputStream.setInput(rowset.getOutput());
        ActivityRequest sourceRequest = new ActivityRequest();
        sourceRequest.add((RequestComponent)sqlQuery);
        sourceRequest.add((RequestComponent)rowset);
        sourceRequest.add((RequestComponent)outputStream);
        sourceRequest.setSessionRequirements((SessionRequirements)new JoinNewSession());
        System.out.println("Performing request at source resource.");
        Response response = sourceService.perform((Request)sourceRequest);
        Session session = response.getSession();
        System.out.println("Response:\n" + response.getAsString());
        DeliverFromDT deliverFromDT = new DeliverFromDT();
        deliverFromDT.setDataTransportInput(outputStream.getDataTransport());
        deliverFromDT.setDataTransportMode(DataTransportMode.BLOCK);
        ActivityRequest sinkRequest = new ActivityRequest();
        sinkRequest.add((RequestComponent)deliverFromDT);
        System.out.println("Performing request at sink resource");
        response = sinkService.perform((Request)sinkRequest);
        System.out.println(response.getAsString());
        System.out.println("Destroying session at source.");
        sourceRequest = new ActivityRequest();
        sourceRequest.setSessionRequirements((SessionRequirements)new TerminateSession(session));
        sourceService.perform((Request)sourceRequest);
    }
}

