/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.delivery.DTOutputStream;
import uk.org.ogsadai.client.toolkit.activity.delivery.DataTransportMode;
import uk.org.ogsadai.client.toolkit.activity.delivery.DeliverFromDT;
import uk.org.ogsadai.client.toolkit.activity.delivery.DeliverFromURL;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLBulkLoad;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLUpdate;
import uk.org.ogsadai.client.toolkit.activity.transform.XSLTransform;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XPathQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.JoinExistingSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionRequirements;

public class DataIntegrationExample {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private static String serviceHandle = "http://localhost:8080/wsrf/services/ogsadai/DataService";

    public static ResourceID chooseResource(String question) throws Exception {
        DataService service = GenericServiceFetcher.getInstance().getDataService(serviceHandle, null);
        ResourceID[] resources = service.getResourceIDs();
        for (int i = 0; i < resources.length; ++i) {
            System.out.println(i + ") " + resources[i].getName());
        }
        System.out.print(question + " (0 - " + (resources.length - 1) + "): \n");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String choiceStr = br.readLine();
        int choice = Integer.parseInt(choiceStr);
        return resources[choice];
    }

    public static void main(String[] args) throws Exception {
        ResourceID sinkResource = DataIntegrationExample.chooseResource("Select resource for sink");
        String tableName = "mytable";
        String createTable = "create table if not exists " + tableName + " (id INTEGER, name VARCHAR(64), " + "address VARCHAR(128), phone VARCHAR(20))";
        SQLUpdate create = new SQLUpdate(createTable);
        System.out.println("Creating new table at sink...");
        DataService sinkService = GenericServiceFetcher.getInstance().getDataService(serviceHandle, null);
        sinkService.setResourceID(sinkResource);
        sinkService.perform((RequestComponent)create);
        System.out.println("Modified rows: " + create.getModifiedRowsCount());
        ResourceID sourceResource = DataIntegrationExample.chooseResource("Select resource for source");
        DataService sourceService = GenericServiceFetcher.getInstance().getDataService(serviceHandle, null);
        sourceService.setResourceID(sourceResource);
        System.out.println("Creating a new session at the source");
        Session session = sourceService.createSession();
        String url = "http://localhost:8080/tutorial/Resource2Result.xsl";
        DeliverFromURL deliver = new DeliverFromURL(url);
        XPathQuery query = new XPathQuery("/entry[@id<50]");
        XSLTransform transform = new XSLTransform();
        transform.setXMLInput(query.getOutput());
        transform.setXSLTInput(deliver.getOutput());
        DTOutputStream outputStream = new DTOutputStream();
        outputStream.setInput(transform.getOutput());
        ActivityRequest sourceRequest = new ActivityRequest();
        sourceRequest.add((RequestComponent)deliver);
        sourceRequest.add((RequestComponent)query);
        sourceRequest.add((RequestComponent)transform);
        sourceRequest.add((RequestComponent)outputStream);
        sourceRequest.setSessionRequirements((SessionRequirements)new JoinExistingSession(session));
        System.out.println("Starting source request...");
        sourceService.perform((Request)sourceRequest);
        DeliverFromDT deliverFromDT = new DeliverFromDT();
        deliverFromDT.setDataTransportInput(outputStream.getDataTransport());
        deliverFromDT.setDataTransportMode(DataTransportMode.BLOCK);
        SQLBulkLoad bulkload = new SQLBulkLoad(deliverFromDT.getOutput(), tableName);
        ActivityRequest sinkRequest = new ActivityRequest();
        sinkRequest.add((RequestComponent)deliverFromDT);
        sinkRequest.add((RequestComponent)bulkload);
        sinkService.perform((Request)sinkRequest);
        System.out.println("Number of inserted rows at sink: " + bulkload.getInsertedRowsCount());
        System.out.println("Destroying session at source.");
        sourceService.closeSession(session);
    }
}

