/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.clienttoolkit;

import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.delivery.DTOutputStream;
import uk.org.ogsadai.client.toolkit.activity.misc.DataStore;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.properties.RequestStatus;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.sessions.JoinExistingSession;
import uk.org.ogsadai.client.toolkit.sessions.JoinNewSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionRequirements;
import uk.org.ogsadai.engine.EngineConstants;

public class AsynchronousRequests {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private static DataService mService;
    private static Session mSession;

    public static void main(String[] args) throws Exception {
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        mService = GenericServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + handle);
        ActivityRequest request = new ActivityRequest();
        DataStore store = new DataStore();
        store.addItem((Object)"one");
        store.addItem((Object)"two");
        store.addItem((Object)"three");
        DTOutputStream output = new DTOutputStream(store.getOutput());
        request.add((RequestComponent)store);
        request.add((RequestComponent)output);
        request.setSessionRequirements((SessionRequirements)new JoinNewSession());
        System.out.println("Performing asynchronous request");
        Response response = mService.perform((Request)request);
        System.out.println("Response:\n" + response.getAsString());
        mSession = response.getSession();
        new Thread(new RequestRunner()).start();
        System.out.println("Request status = " + mService.getStatus(mSession.getSessionID()));
        DataTransport dt = output.getDataTransport();
        Object block = dt.getBlock();
        while (!block.equals(EngineConstants.NO_MORE_DATA)) {
            System.out.println("Received block: " + block);
            block = dt.getBlock();
        }
    }

    static class RequestRunner
    implements Runnable {
        RequestRunner() {
        }

        public void run() {
            try {
                System.out.println("THREAD: Starting to poll service until request completed");
                mService.pollUntilRequestCompleted(mSession.getSessionID(), 10);
                System.out.println("THREAD: First request completed");
                System.out.println("THREAD: Request status = " + mSession.getStatus());
                ActivityRequest request = new ActivityRequest();
                System.out.println("THREAD: About to run query request");
                SQLQuery query = new SQLQuery("select * from littleblackbook where id=9127");
                WebRowSet rowset = new WebRowSet(query.getOutput());
                request.add((RequestComponent)query);
                request.add((RequestComponent)rowset);
                request.setSessionRequirements((SessionRequirements)new JoinExistingSession(mSession));
                mService.perform((Request)request);
                if (mSession.getStatus() == RequestStatus.COMPLETED) {
                    System.out.println("THREAD: Query request completed successfully");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

