/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.authorization;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.examples.authorization.SimpleFileAuthorizer;

public class UpdateableFileAuthorizer
extends SimpleFileAuthorizer {
    private final String configPath;

    public UpdateableFileAuthorizer(String config) throws Exception {
        super(config);
        this.configPath = config;
    }

    public synchronized boolean authorizeResource(String resourceID, SecurityContext context) {
        return super.authorizeResource(resourceID, context);
    }

    public synchronized boolean authorizeActivity(String resourceID, Activity activity, SecurityContext context) {
        return super.authorizeActivity(resourceID, activity, context);
    }

    public synchronized void grantResourceAccessToUser(String resourceID, String userDN) throws Exception {
        HashSet<String> users = (HashSet<String>)this.resourceAuthorization.get(resourceID);
        if (users != null) {
            users.add(userDN);
        } else {
            users = new HashSet<String>();
            users.add(userDN);
            this.resourceAuthorization.put(resourceID, users);
        }
        this.writeConfiguration();
    }

    public synchronized void grantActivityAccessToUser(String activityName, String resourceID, String userDN) throws Exception {
        HashSet<String> users = (HashSet<String>)this.activityAuthorization.get(activityName);
        if (users != null) {
            users.add(userDN);
        } else {
            users = new HashSet<String>();
            users.add(userDN);
            this.activityAuthorization.put(activityName, users);
        }
        this.writeConfiguration();
    }

    public synchronized boolean removeUserFromResourceAccess(String resourceID, String userDN) throws Exception {
        boolean removed = false;
        Set users = (Set)this.resourceAuthorization.get(resourceID);
        if (users != null) {
            removed = users.remove(userDN);
            if (users.isEmpty()) {
                this.resourceAuthorization.remove(resourceID);
            }
            this.writeConfiguration();
        }
        return removed;
    }

    public synchronized boolean removeUserFromActivityAccess(String activityName, String resourceID, String userDN) throws Exception {
        boolean removed = false;
        Set users = (Set)this.activityAuthorization.get(activityName);
        if (users != null) {
            removed = users.remove(userDN);
            if (users.isEmpty()) {
                this.activityAuthorization.remove(activityName);
            }
            this.writeConfiguration();
        }
        return removed;
    }

    private void writeConfiguration() throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\"?>\n");
        xml.append("<authorization>\n");
        this.writeUsers(xml, this.resourceAuthorization, "resource", "id");
        this.writeUsers(xml, this.activityAuthorization, "activity", "name");
        xml.append("</authorization>\n");
        FileUtilities.deleteFile((String)this.configPath);
        FileUtilities.writeStringToFile((String)this.configPath, (String)xml.toString());
    }

    private void writeUsers(StringBuffer xml, Map map, String element, String attr) {
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            xml.append("  <");
            xml.append(element);
            xml.append(" ");
            xml.append(attr);
            xml.append("=\"");
            xml.append(key);
            xml.append("\">\n");
            Iterator users = ((Set)map.get(key)).iterator();
            while (users.hasNext()) {
                xml.append("    <user dn=\"");
                xml.append(users.next().toString());
                xml.append("\" />\n");
            }
            xml.append("  </");
            xml.append(element);
            xml.append(">\n");
        }
    }
}

