/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.examples.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;

public class SimpleFileAuthorizer
implements AccessAuthorizer {
    protected Map resourceAuthorization = new HashMap();
    protected Map activityAuthorization = new HashMap();

    public SimpleFileAuthorizer(String config) throws Exception {
        Document doc = XMLUtilities.xmlFileToDOM((String)config, (boolean)false);
        NodeList resources = doc.getElementsByTagName("resource");
        for (int j = 0; j < resources.getLength(); ++j) {
            Element resource = (Element)resources.item(j);
            String resourceID = resource.getAttribute("id");
            HashSet<String> authorizedUsers = new HashSet<String>();
            NodeList users = resource.getElementsByTagName("user");
            for (int i = 0; i < users.getLength(); ++i) {
                String userDN = ((Element)users.item(i)).getAttribute("dn");
                authorizedUsers.add(userDN);
            }
            this.resourceAuthorization.put(resourceID, authorizedUsers);
        }
        NodeList activities = doc.getElementsByTagName("activity");
        for (int j = 0; j < activities.getLength(); ++j) {
            Element activity = (Element)activities.item(j);
            String activityName = activity.getAttribute("name");
            HashSet<String> authorizedUsers = new HashSet<String>();
            NodeList users = activity.getElementsByTagName("user");
            for (int i = 0; i < users.getLength(); ++i) {
                String userDN = ((Element)users.item(i)).getAttribute("dn");
                authorizedUsers.add(userDN);
            }
            this.activityAuthorization.put(activityName, authorizedUsers);
        }
    }

    public boolean authorizeResource(String resourceID, SecurityContext context) {
        if (context == null) {
            return false;
        }
        Set users = (Set)this.resourceAuthorization.get(resourceID);
        if (users == null) {
            return false;
        }
        return users.contains(context.getDN());
    }

    public boolean authorizeActivity(String resourceID, Activity activity, SecurityContext context) {
        if (context == null) {
            return false;
        }
        Set users = (Set)this.activityAuthorization.get(activity.getActivityName());
        if (users == null) {
            return false;
        }
        return users.contains(context.getDN());
    }
}

