/*
 * Decompiled with CFR 0.152.
 */
package org.globus.registry;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.registry.AxisServiceGroupEntry;
import org.globus.util.I18n;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.RemoveNotSupportedException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.oasis.wsrf.servicegroup.EntryType;

public class AxisRegistryHome
implements ResourceHome {
    private static final I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = AxisRegistryHome.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$registry$AxisRegistryHome == null ? (class$org$globus$registry$AxisRegistryHome = AxisRegistryHome.class$("org.globus.registry.AxisRegistryHome")) : class$org$globus$registry$AxisRegistryHome).getName());
    private static final int TIMEOUT = 300000;
    private static final QName KEY = new QName("http://axis.org", "ServiceName");
    private AxisEngine engine;
    private WSDDDeployment deployment;
    private EndpointReferenceType serviceGroupEPR;
    private String serviceGroupServiceName;
    private String serviceGroupEntryServiceName;
    private String baseURL;
    private Map services;
    private long lastRefresh;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$org$globus$registry$AxisRegistryHome;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$axis$WSDDEngineConfiguration;

    public Class getKeyTypeClass() {
        return class$java$lang$String == null ? (class$java$lang$String = AxisRegistryHome.class$("java.lang.String")) : class$java$lang$String;
    }

    public QName getKeyTypeName() {
        return KEY;
    }

    public void setServiceGroupServiceName(String name) {
        this.serviceGroupServiceName = name;
    }

    public String getServiceGroupServiceName() {
        return this.serviceGroupServiceName;
    }

    public AxisRegistryHome() {
        MessageContext ctx = MessageContext.getCurrentContext();
        this.serviceGroupEntryServiceName = ctx.getTargetService();
    }

    private synchronized void init() throws Exception {
        if (this.baseURL != null) {
            return;
        }
        MessageContext context = MessageContext.getCurrentContext();
        if (context == null) {
            throw new Exception(i18n.getMessage("noMsgContext"));
        }
        this.engine = context.getAxisEngine();
        EngineConfiguration config = this.engine.getConfig();
        if (!(config instanceof WSDDEngineConfiguration)) {
            Object[] args = new Object[]{class$org$apache$axis$WSDDEngineConfiguration == null ? (class$org$apache$axis$WSDDEngineConfiguration = AxisRegistryHome.class$("org.apache.axis.WSDDEngineConfiguration")) : class$org$apache$axis$WSDDEngineConfiguration, config == null ? null : config.getClass()};
            throw new Exception(i18n.getMessage("expectedType", args));
        }
        this.deployment = ((WSDDEngineConfiguration)config).getDeployment();
        String transURL = (String)context.getProperty("transport.url");
        if (transURL == null) {
            throw new Exception(i18n.getMessage("noTransURL"));
        }
        ContainerConfig conConfig = ContainerConfig.getConfig((AxisEngine)this.engine);
        URL url = new URL(transURL);
        URL basicURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/" + conConfig.getWSRFLocation());
        this.baseURL = basicURL.toString();
        this.serviceGroupEPR = this.getEPR(this.serviceGroupServiceName);
    }

    private synchronized void refresh() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRefresh > 300000L) {
            try {
                this.init();
                this.createEntries();
                this.lastRefresh = currentTime;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to initialize registry", (Throwable)e);
            }
        }
    }

    private synchronized void createEntries() throws Exception {
        this.services = new HashMap();
        WSDDService[] services = this.deployment.getServices();
        SimpleResourceKey key = null;
        AxisServiceGroupEntry entry = null;
        EndpointReferenceType sgeEPR = null;
        EndpointReferenceType memberEPR = null;
        for (int i = 0; i < services.length; ++i) {
            String serviceName = services[i].getQName().getLocalPart();
            key = new SimpleResourceKey(KEY, (Object)serviceName);
            sgeEPR = this.getSGEEPR(this.serviceGroupEntryServiceName, serviceName);
            memberEPR = this.getEPR(serviceName);
            entry = new AxisServiceGroupEntry(sgeEPR, this.serviceGroupEPR, memberEPR);
            this.services.put(key, entry);
        }
    }

    public Resource find(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException {
        if (key == null) {
            throw new InvalidResourceKeyException();
        }
        this.refresh();
        Map srvs = this.services;
        if (srvs == null) {
            throw new NoSuchResourceException();
        }
        Resource service = (Resource)srvs.get(key);
        if (service == null) {
            throw new NoSuchResourceException();
        }
        return service;
    }

    public void remove(ResourceKey key) throws ResourceException {
        throw new RemoveNotSupportedException();
    }

    protected EntryType[] getEntries() {
        this.refresh();
        Map srvs = this.services;
        if (srvs == null) {
            return null;
        }
        EntryType[] entries = new EntryType[srvs.size()];
        Iterator iter = srvs.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            AxisServiceGroupEntry entry = (AxisServiceGroupEntry)iter.next().getValue();
            entries[i] = new EntryType();
            entries[i].setMemberServiceEPR(entry.getMemberEPR());
            entries[i].setServiceGroupEntryEPR(entry.getServiceGroupEntryEPR());
            entries[i].setContent(entry.getContent());
            ++i;
        }
        return entries;
    }

    private EndpointReferenceType getSGEEPR(String service, String serviceName) throws Exception {
        EndpointReferenceType epr = this.getEPR(service);
        ReferencePropertiesType refProps = new ReferencePropertiesType();
        SimpleResourceKey key = new SimpleResourceKey(KEY, (Object)serviceName);
        refProps.add((Object)key.toSOAPElement());
        epr.setProperties(refProps);
        return epr;
    }

    private EndpointReferenceType getEPR(String service) throws IOException {
        EndpointReferenceType epr = new EndpointReferenceType();
        epr.setAddress(new AttributedURI(this.baseURL + service));
        epr.setProperties(null);
        return epr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

