/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ServerConfigure {
    private String servername = null;
    private String serverdescription = null;
    private String registryurl = null;
    private String workthreadnum = null;
    private String jobvalidperiod = null;
    private String discoverperiod = null;
    private String vostorageurl = null;
    private String sessionidleperiod = null;

    public String getJobvalidperiod() {
        return this.jobvalidperiod;
    }

    public void setJobvalidperiod(String jobvalidperiod) {
        this.jobvalidperiod = jobvalidperiod;
    }

    public String getSessionidleperiod() {
        return this.sessionidleperiod;
    }

    public void setSessionidleperiod(String sessionidleperiod) {
        this.sessionidleperiod = sessionidleperiod;
    }

    public String getRegistryurl() {
        return this.registryurl;
    }

    public void setRegistryurl(String registryurl) {
        this.registryurl = registryurl;
    }

    public String getServerdescription() {
        return this.serverdescription;
    }

    public void setServerdescription(String serverdescription) {
        this.serverdescription = serverdescription;
    }

    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public String getVostorageurl() {
        return this.vostorageurl;
    }

    public void setVostorageurl(String vostorageurl) {
        this.vostorageurl = vostorageurl;
    }

    public String getWorkthreadnum() {
        return this.workthreadnum;
    }

    public void setWorkthreadnum(String workthreadnum) {
        this.workthreadnum = workthreadnum;
    }

    public void parseConfigureFile(String filepath) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException e) {
                System.err.println("WARNING: " + e.getMessage());
            }

            public void error(SAXParseException e) {
                System.err.println("ERROR: " + e.getMessage());
            }

            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("FATAL: " + e.getMessage());
                throw e;
            }
        });
        Document document = parser.parse(filepath);
        NodeList servernode = document.getElementsByTagName("Server");
        Element dbrTag = (Element)servernode.item(0);
        this.setServername(this.getNodeValue(dbrTag, "ServerName"));
        this.setServerdescription(this.getNodeValue(dbrTag, "ServerDescription"));
        this.setRegistryurl(this.getNodeValue(dbrTag, "RegistryURL"));
        this.setWorkthreadnum(this.getNodeValue(dbrTag, "WorkThreadNum"));
        this.setJobvalidperiod(this.getNodeValue(dbrTag, "JobValidPeriod"));
        this.setSessionidleperiod(this.getNodeValue(dbrTag, "SessionIdlePeriod"));
        this.setDiscoverperiod(this.getNodeValue(dbrTag, "DiscoverPeriod"));
        this.setVostorageurl(this.getNodeValue(dbrTag, "VOStorageURL"));
    }

    public String getFilePath() {
        String filepath = null;
        try {
            Properties ps = this.getEnv();
            filepath = ps.getProperty("CATALINA_HOME");
            filepath = filepath.replace("'", "");
            String OS = System.getProperty("os.name").toLowerCase();
            if (OS.indexOf("windows") > -1) {
                filepath = String.valueOf(filepath) + "\\das\\server.xml";
            } else if (OS.indexOf("linux") > -1) {
                filepath = String.valueOf(filepath) + "/das/server.xml";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filepath;
    }

    public Properties getEnv() throws Exception {
        String line;
        Properties prop = new Properties();
        String OS = System.getProperty("os.name").toLowerCase();
        Process p = null;
        if (OS.indexOf("windows") > -1) {
            p = Runtime.getRuntime().exec("cmd /c set");
        }
        if (OS.indexOf("linux") > -1) {
            p = Runtime.getRuntime().exec("sh -c set");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = br.readLine()) != null) {
            int i = line.indexOf("=");
            if (i <= -1) continue;
            String key = line.substring(0, i);
            String value = line.substring(i + 1);
            prop.setProperty(key, value);
        }
        return prop;
    }

    public String getNodeValue(Element bigTag, String nodeName) throws NullPointerException {
        Node aTag2;
        block7: {
            aTag2 = bigTag.getElementsByTagName(nodeName).item(0);
            if (aTag2.getFirstChild() != null) break block7;
            System.out.println("Found node like <**></**>");
            return "NOT PROVIDED";
        }
        try {
            String tagName = ((Element)aTag2).getTagName();
            if (tagName.equals("Subject") || tagName.equals("Instrument") || tagName.equals("ContentLevel") || tagName.equals("CoverageSpectral")) {
                NodeList stringList = ((Element)aTag2).getElementsByTagName("string");
                int stringNum = stringList.getLength();
                String strings = "";
                int i = 0;
                while (i < stringNum) {
                    if (stringList.item(i).getFirstChild() == null) {
                        System.out.println("Found node like <ContentLevel>\n<string/>\n</ContentLevel>");
                        strings = String.valueOf(strings) + "NOT PROVIDED\n";
                    } else {
                        strings = String.valueOf(strings) + ((Text)stringList.item(i).getFirstChild()).getData().trim() + "\n";
                    }
                    ++i;
                }
                return String.valueOf(stringNum) + "\t" + strings;
            }
            String tagvalue2 = ((Text)aTag2.getFirstChild()).getData().trim();
            return tagvalue2;
        }
        catch (NullPointerException e) {
            System.out.println("The nodename is not supported!");
            return "NOT PROVIDED";
        }
    }

    public String getDiscoverperiod() {
        return this.discoverperiod;
    }

    public void setDiscoverperiod(String discoverperiod) {
        this.discoverperiod = discoverperiod;
    }
}

