/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.registry;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.china.vo.das.registry.MDTable;
import org.china.vo.das.registry.RegistryProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestXML {
    Document document;
    int numservlets;
    NodeList servletnodes = null;

    public TestXML(String fname) throws IOException, SAXException, ParserConfigurationException {
        File configfile = new File(fname);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException e) {
                System.err.println("WARNING: " + e.getMessage());
            }

            public void error(SAXParseException e) {
                System.err.println("ERROR: " + e.getMessage());
            }

            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("FATAL: " + e.getMessage());
                throw e;
            }
        });
        this.document = parser.parse(configfile);
        NodeList servletnodes = this.document.getElementsByTagName("TABLE");
        this.numservlets = servletnodes.getLength();
        System.out.println(this.numservlets);
        Element tableTag = (Element)servletnodes.item(0);
        System.out.println(RegistryProxy.getNodeValue(tableTag, "DESCRIPTION"));
        String tableName = tableTag.getAttribute("name");
        System.out.println(tableName);
        NodeList fieldList = tableTag.getElementsByTagName("FIELD");
        System.out.println(fieldList.getLength());
        String namedata2 = ((Element)fieldList.item(0)).getAttribute("ucd");
        System.out.println("the ucd\t" + namedata2);
        System.out.println(fieldList.item(5).hasChildNodes());
        Element decTag = (Element)fieldList.item(5);
        NodeList declist = decTag.getElementsByTagName("DESCRIPTION");
        System.out.println(declist.getLength());
        System.out.println(declist.item(0).hasChildNodes());
        String dec = ((Text)declist.item(0).getFirstChild()).getData().trim();
        System.out.println(dec);
        MDTable mdt = new MDTable();
        System.out.println("columns number is :" + mdt.getColumnsNum());
    }

    public String getValue(int drNum, String tagName) {
        Element dbrTag = (Element)this.servletnodes.item(drNum);
        Element aTag = (Element)dbrTag.getElementsByTagName(tagName).item(0);
        String tagvalue = ((Text)aTag.getFirstChild()).getData().trim();
        return tagvalue;
    }

    public static void main(String[] args) throws Exception {
        try {
            TestXML txml = new TestXML("F:\\Temp\\votable_3galx_delData.xml");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

