/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.registry;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.china.vo.das.datanode.DataResource;
import org.china.vo.das.datanode.DataResourceMap;
import org.china.vo.das.registry.MDDataResource;
import org.china.vo.das.registry.MDItemCollection;
import org.china.vo.das.registry.MDItemCoverage;
import org.china.vo.das.registry.MDItemCuration;
import org.china.vo.das.registry.MDItemDataQuality;
import org.china.vo.das.registry.MDItemGeneralContent;
import org.china.vo.das.registry.MDItemIdentity;
import org.china.vo.das.registry.MDItemResolution;
import org.china.vo.das.registry.MDItemService;
import org.china.vo.das.registry.MDItemServiceCapibility;
import org.china.vo.das.registry.MDItemServiceInterface;
import org.china.vo.das.registry.MetaData;
import org.china.vo.das.service.ServerConfigure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RegistryProxy {
    private String thefile = null;

    public RegistryProxy() {
        ServerConfigure sc = new ServerConfigure();
        String filepath = sc.getFilePath();
        try {
            sc.parseConfigureFile(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.thefile = sc.getRegistryurl();
    }

    public void discover(DataResourceMap dataResourceMap) throws Exception {
        this.dealXML(dataResourceMap);
    }

    public void dealXML(DataResourceMap dataResourceMap) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException e) {
                System.err.println("WARNING: " + e.getMessage());
            }

            public void error(SAXParseException e) {
                System.err.println("ERROR: " + e.getMessage());
            }

            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("FATAL: " + e.getMessage());
                throw e;
            }
        });
        Document document = parser.parse(this.thefile);
        NodeList servletnodes = document.getElementsByTagName("DBResource");
        int numservlets = servletnodes.getLength();
        System.out.println("Now make the DataResources and put them to Map");
        int i = 0;
        while (i < numservlets) {
            block3: {
                System.out.println("Begin make\t NO." + (i + 1) + "   DBResource");
                Element dbrTag = (Element)servletnodes.item(i);
                MDDataResource mdDR = new MDDataResource();
                MDItemDataQuality itemdataQ = new MDItemDataQuality();
                MDItemIdentity itemItemI = new MDItemIdentity();
                MDItemCuration itemCuration = new MDItemCuration();
                MDItemGeneralContent itemG = new MDItemGeneralContent();
                MDItemService itemS = new MDItemService();
                MDItemCollection itemCollection = new MDItemCollection();
                MDItemServiceInterface itemSI = new MDItemServiceInterface();
                MDItemServiceCapibility itemSC = new MDItemServiceCapibility();
                MDItemResolution itemR = new MDItemResolution();
                MDItemCoverage itemCoverage = new MDItemCoverage();
                System.out.println("finished init");
                mdDR.setQuality(itemdataQ);
                itemItemI.setTitle(RegistryProxy.getNodeValue(dbrTag, "Title"));
                itemItemI.setShortname(RegistryProxy.getNodeValue(dbrTag, "ShortName"));
                itemItemI.setIdentifier(RegistryProxy.getNodeValue(dbrTag, "Identifier"));
                System.out.println("get indentity succesfully");
                mdDR.setIdentity(itemItemI);
                itemCuration.setPublisher(RegistryProxy.getNodeValue(dbrTag, "CurationPublisherName"));
                itemCuration.setPublisherID(RegistryProxy.getNodeValue(dbrTag, "CurationPublisherIdentifier"));
                itemCuration.setPublisherdescription(RegistryProxy.getNodeValue(dbrTag, "CurationPublisherDescription"));
                itemCuration.setPublisherreferenceurl(RegistryProxy.getNodeValue(dbrTag, "CurationPublisherReferenceUrl"));
                itemCuration.setCreator(RegistryProxy.getNodeValue(dbrTag, "CurationCreatorName"));
                itemCuration.setContributor(RegistryProxy.getNodeValue(dbrTag, "CurationContributor"));
                itemCuration.setDate(RegistryProxy.getNodeValue(dbrTag, "CurationDate"));
                itemCuration.setVersion(RegistryProxy.getNodeValue(dbrTag, "CurationVersion"));
                itemCuration.setContactname(RegistryProxy.getNodeValue(dbrTag, "CurationContactName"));
                itemCuration.setContactemail(RegistryProxy.getNodeValue(dbrTag, "CurationContactEmail"));
                mdDR.setCuration(itemCuration);
                itemG.setSubject(RegistryProxy.getNodeValue(dbrTag, "Subject"));
                itemG.setDescription(RegistryProxy.getNodeValue(dbrTag, "Description"));
                itemG.setReferenceURL(RegistryProxy.getNodeValue(dbrTag, "ReferenceURL"));
                itemG.setType(RegistryProxy.getNodeValue(dbrTag, "Type"));
                itemG.setContentlevel(RegistryProxy.getNodeValue(dbrTag, "ContentLevel"));
                mdDR.setGeneralcontent(itemG);
                itemSI.setInterfaceURL(RegistryProxy.getNodeValue(dbrTag, "ServiceURL"));
                itemS.setInterfaces(itemSI);
                itemSC.setMaxRecords(RegistryProxy.getNodeValue(dbrTag, "MaxRecords"));
                itemS.setCapibility(itemSC);
                mdDR.setService(itemS);
                mdDR.setDNType(RegistryProxy.getNodeValue(dbrTag, "Type"));
                itemCollection.setFacility(RegistryProxy.getNodeValue(dbrTag, "Facility"));
                itemCollection.setInstrument(RegistryProxy.getNodeValue(dbrTag, "Instrument"));
                itemCoverage.setSpatial(RegistryProxy.getNodeValue(dbrTag, "CoverageSpatial"));
                itemCoverage.setSpcectral(RegistryProxy.getNodeValue(dbrTag, "CoverageSpectral"));
                itemCoverage.setRegionofregards(RegistryProxy.getNodeValue(dbrTag, "CoverageRegionOfRegard"));
                itemR.setTemporal(RegistryProxy.getNodeValue(dbrTag, "CoverageTemporal"));
                itemCollection.setResolution(itemR);
                itemCollection.setCoverage(itemCoverage);
                mdDR.setCollection(itemCollection);
                mdDR.setXmlString(RegistryProxy.NodetoString(servletnodes.item(i)));
                try {
                    mdDR.setTables(itemSI.getInterfaceURL());
                }
                catch (Exception e) {
                    System.out.println("Can't make\t NO." + (i + 1) + "  DBResource");
                    System.err.println(e);
                    break block3;
                }
                DataResource dr = new DataResource();
                dr.setDrMDDataResource(mdDR);
                dataResourceMap.dataResourceMap.put(dr.getDrMDDataResource().getIdentity().getTitle(), dr);
                System.out.println("finish make\t NO." + (i + 1) + "  DBResource");
            }
            ++i;
        }
    }

    public static String getNodeValue(Element bigTag, String nodeName) throws NullPointerException {
        Node aTag2;
        block7: {
            System.out.println("Inside getNodeValue\t" + nodeName + "\t");
            aTag2 = bigTag.getElementsByTagName(nodeName).item(0);
            if (aTag2.getFirstChild() != null) break block7;
            System.out.println("Found node like <**></**>");
            return "NOT PROVIDED";
        }
        try {
            String tagName = ((Element)aTag2).getTagName();
            if (tagName.equals("Subject") || tagName.equals("Instrument") || tagName.equals("ContentLevel") || tagName.equals("CoverageSpectral")) {
                NodeList stringList = ((Element)aTag2).getElementsByTagName("string");
                int stringNum = stringList.getLength();
                String strings = "";
                int i = 0;
                while (i < stringNum) {
                    if (stringList.item(i).getFirstChild() == null) {
                        System.out.println("Found node like <ContentLevel>\n<string/>\n</ContentLevel>");
                        strings = String.valueOf(strings) + "NOT PROVIDED\n";
                    } else {
                        strings = String.valueOf(strings) + ((Text)stringList.item(i).getFirstChild()).getData().trim() + "\n";
                    }
                    ++i;
                }
                return String.valueOf(stringNum) + "\t" + strings;
            }
            String tagvalue2 = ((Text)aTag2.getFirstChild()).getData().trim();
            return tagvalue2;
        }
        catch (NullPointerException e) {
            System.out.println("The nodename is not supported!");
            return "NOT PROVIDED";
        }
    }

    public static String NodetoString(Node node) {
        Transformer transformer = null;
        String result = null;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (transformer != null) {
            try {
                StringWriter sw = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(sw));
                return sw.toString();
            }
            catch (TransformerException te) {
                throw new RuntimeException(te.getMessage());
            }
        }
        return result;
    }

    public String getname(MetaData theMetaData) {
        return theMetaData.getIdentity().getTitle();
    }

    public String getInterfaceURL(MetaData theMetaData) {
        return theMetaData.getService().getInterfaces().getInterfaceURL();
    }

    public static void main(String[] args) {
        try {
            DataResourceMap drM = DataResourceMap.getInstance();
            RegistryProxy rp = new RegistryProxy();
            rp.discover(drM);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

