/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.registry;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.china.vo.das.registry.MDField;
import org.china.vo.das.registry.MDItemCollection;
import org.china.vo.das.registry.MDItemCuration;
import org.china.vo.das.registry.MDItemDataQuality;
import org.china.vo.das.registry.MDItemGeneralContent;
import org.china.vo.das.registry.MDItemIdentity;
import org.china.vo.das.registry.MDItemService;
import org.china.vo.das.registry.MDTable;
import org.china.vo.das.registry.MetaData;
import org.china.vo.das.registry.RegistryProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MDDataResource
extends MetaData {
    private MDItemCollection collection;
    private MDItemCuration curation;
    private MDItemGeneralContent generalcontent;
    private MDItemIdentity identity;
    private MDItemDataQuality quality;
    private MDItemService Service;
    private String xmlString = "";
    private ArrayList tables = new ArrayList();
    private String DNType;

    public int getTableNum() {
        return this.tables.size();
    }

    public boolean hasTable(String tableName) {
        int tableNum = 0;
        while (tableNum < this.tables.size()) {
            MDTable mdTable = (MDTable)this.tables.get(tableNum);
            if (mdTable.getName().equals(tableName)) {
                return true;
            }
            ++tableNum;
        }
        return false;
    }

    public boolean hasColumn(String TableName, String ColumnName) {
        int tableNum = 0;
        while (tableNum < this.tables.size()) {
            MDTable mdTable = (MDTable)this.tables.get(tableNum);
            if (mdTable.getName().equals(TableName)) {
                ArrayList colList = mdTable.getColumns();
                int j = 0;
                while (j < colList.size()) {
                    MDField mdfield = (MDField)colList.get(j);
                    if (mdfield.getname().equals(ColumnName)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++tableNum;
        }
        return false;
    }

    public void setDNType(String newDNType) {
        this.DNType = newDNType;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
    }

    public String getDNType() {
        return this.generalcontent.getType();
    }

    public MDItemCollection getCollection() {
        return this.collection;
    }

    public void setCollection(MDItemCollection collection) {
        this.collection = collection;
    }

    public MDItemCuration getCuration() {
        return this.curation;
    }

    public void setCuration(MDItemCuration curation) {
        this.curation = curation;
    }

    public MDItemGeneralContent getGeneralcontent() {
        return this.generalcontent;
    }

    public void setGeneralcontent(MDItemGeneralContent generalcontent) {
        this.generalcontent = generalcontent;
    }

    public MDItemIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(MDItemIdentity identity) {
        this.identity = identity;
    }

    public MDItemDataQuality getQuality() {
        return this.quality;
    }

    public void setQuality(MDItemDataQuality quality) {
        this.quality = quality;
    }

    public MDItemService getService() {
        return this.Service;
    }

    public void setService(MDItemService service) {
        this.Service = service;
    }

    public ArrayList getTables() {
        return this.tables;
    }

    public void setTables(String tableurl) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException e) {
                System.err.println("WARNING: " + e.getMessage());
            }

            public void error(SAXParseException e) {
                System.err.println("ERROR: " + e.getMessage());
            }

            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("FATAL: " + e.getMessage());
                throw e;
            }
        });
        String[] tu = tableurl.split("/");
        tableurl = String.valueOf(tu[0]) + "/" + tu[1] + "/" + tu[2] + "/metadata.xml";
        Document document = parser.parse(tableurl);
        NodeList tableNodes = document.getElementsByTagName("TABLE");
        int tableNum = tableNodes.getLength();
        System.out.println("The DBResource has " + tableNum + "  tables");
        int i = 0;
        while (i < tableNum) {
            MDTable mdTable = new MDTable();
            Element tableTag = (Element)tableNodes.item(i);
            System.out.println("Begin make the NO." + (i + 1) + " table!");
            mdTable.setName(tableTag.getAttribute("name"));
            mdTable.setDescription(RegistryProxy.getNodeValue(tableTag, "DESCRIPTION"));
            System.out.println("Finished get the tables description!");
            NodeList fieldList = tableTag.getElementsByTagName("FIELD");
            int fieldNum = fieldList.getLength();
            System.out.println("This table has " + fieldNum + " cloumns");
            int j = 0;
            while (j < fieldNum) {
                System.out.println("Begin making NO." + (j + 1) + " cloumns");
                MDField mdField = new MDField();
                mdField.setname(((Element)fieldList.item(j)).getAttribute("name"));
                mdField.setucd(((Element)fieldList.item(j)).getAttribute("ucd"));
                mdField.setunit(((Element)fieldList.item(j)).getAttribute("unit"));
                mdField.setdatatype(((Element)fieldList.item(j)).getAttribute("datatype"));
                mdField.setWidth(((Element)fieldList.item(j)).getAttribute("width"));
                mdField.setPrecision(((Element)fieldList.item(j)).getAttribute("precision"));
                mdField.setID(((Element)fieldList.item(j)).getAttribute("ID"));
                mdField.setdescription(this.getFieldDes(fieldList.item(j)));
                mdField.setXmlString(RegistryProxy.NodetoString(fieldList.item(j)));
                mdTable.setColumns(mdField);
                System.out.println("check the columns in this table now is: " + mdTable.getColumnsNum());
                System.out.println("check the MDField xmlString: " + mdField.getXmlString());
                System.out.println("set mdfield successfully");
                ++j;
            }
            String tablexml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><TABLE name=\"" + mdTable.getName() + "\"><DESCRIPTION>" + mdTable.getDescription() + "</DESCRIPTION></TABLE>";
            mdTable.setXmlString(tablexml);
            System.out.println("The XMLString of this table is :" + tablexml);
            this.tables.add(mdTable);
            System.out.println("Now we have add " + this.getTableNum() + " tables");
            ++i;
        }
        System.out.println("Now we have add " + this.getTableNum() + " tables");
    }

    public String getFieldDes(Node fieldNode) {
        if (fieldNode.hasChildNodes()) {
            Element decTag = (Element)fieldNode;
            NodeList declist = decTag.getElementsByTagName("DESCRIPTION");
            String dec = ((Text)declist.item(0).getFirstChild()).getData().trim();
            return dec;
        }
        return "NOT PROVIDED";
    }

    public String getSpecFilePathColumn(String tablename) {
        String pathname = "";
        int tableNum = 0;
        while (tableNum < this.tables.size()) {
            MDTable mdTable = (MDTable)this.tables.get(tableNum);
            if (mdTable.getName().equals(tablename)) {
                ArrayList colList = mdTable.getColumns();
                int j = 0;
                while (j < colList.size()) {
                    MDField mdfield = (MDField)colList.get(j);
                    if (mdfield.getucd().equalsIgnoreCase("meta.ref.uri")) {
                        pathname = mdfield.getname();
                        break;
                    }
                    ++j;
                }
            }
            ++tableNum;
        }
        return pathname;
    }
}

