/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import net.ivoa.adql.ADQLBuiltInFunction;
import net.ivoa.adql.ADQLComment;
import net.ivoa.adql.ADQLInteger;
import net.ivoa.adql.ADQLOperator;
import net.ivoa.adql.ADQLReal;
import net.ivoa.adql.ADQLSysVariable;
import net.ivoa.adql.ADQLToken;
import net.ivoa.adql.ADQLVariable;
import net.ivoa.adql.And;
import net.ivoa.adql.ArchiveTable;
import net.ivoa.adql.ArchiveTableItem;
import net.ivoa.adql.Column;
import net.ivoa.adql.Comma;
import net.ivoa.adql.CompareOp;
import net.ivoa.adql.DBObject;
import net.ivoa.adql.Eof;
import net.ivoa.adql.ExplicitFunction;
import net.ivoa.adql.Expression;
import net.ivoa.adql.From;
import net.ivoa.adql.Function;
import net.ivoa.adql.Identifier;
import net.ivoa.adql.JoinedTable;
import net.ivoa.adql.Keyword;
import net.ivoa.adql.LParam;
import net.ivoa.adql.Not;
import net.ivoa.adql.Or;
import net.ivoa.adql.QuoteIdentifier;
import net.ivoa.adql.RParam;
import net.ivoa.adql.Region;
import net.ivoa.adql.SearchCondition;
import net.ivoa.adql.SelectClause;
import net.ivoa.adql.SelectItem;
import net.ivoa.adql.SelectList;
import net.ivoa.adql.SelectStatement;
import net.ivoa.adql.Star;
import net.ivoa.adql.SubTableSource;
import net.ivoa.adql.TableColumns;
import net.ivoa.adql.Where;
import net.ivoa.adql.XMatch;
import org.china.vo.das.exceptions.ParserExpressionException;
import org.china.vo.das.exceptions.ParserSyntaxException;
import org.china.vo.das.log.DASLog;

public class ADQLParser {
    private final int st_at1 = 0;
    private final int st_at2 = 1;
    private final int st_bif = 2;
    private final int st_cl1 = 3;
    private final int st_cl2 = 4;
    private final int st_cm1 = 5;
    private final int st_cm2 = 6;
    private final int st_db1 = 7;
    private final int st_db2 = 8;
    private final int st_dq1 = 9;
    private final int st_dq2 = 10;
    private final int st_end = -2;
    private final int st_err = -1;
    private final int st_lit = 11;
    private final int st_nul = 12;
    private final int st_num = 13;
    private final int st_op1 = 14;
    private final int st_qlt = 15;
    private final int st_rl1 = 16;
    private final int st_rl2 = 17;
    private final int st_sla = 18;
    private final int st_sta = 19;
    private final int st_str = 20;
    private final int st_sn1 = 21;
    private final int st_sn2 = 22;
    private final int st_sn3 = 23;
    private final int st_svr = 24;
    private final int st_tbc = 25;
    private final int st_var = 26;
    private final int est_nul = 0;
    private final int est_od = 1;
    private final int est_op1 = 2;
    private final int est_op2 = 3;
    private final int est_sta = 4;
    private final int est_setop = 5;
    private final int est_end = -1;
    private final int est_err = 6;
    private int s = 12;
    private int exprs = 0;
    private String chs = "";
    private ADQLToken tkn = null;
    private int m_nOffset = 0;
    private int m_nPref = 1;
    private int m_nLParam = 0;
    private LinkedList m_strDelimiter = null;
    private String m_strAdql = null;
    private HashMap keywords = new HashMap(200);
    private HashMap functions = new HashMap();

    public ADQLParser() {
        this.keywords.put("add", "add");
        this.keywords.put("all", "all");
        this.keywords.put("alter", "alter");
        this.keywords.put("and", "and");
        this.keywords.put("any", "any");
        this.keywords.put("as", "as");
        this.keywords.put("asc", "asc");
        this.keywords.put("add", "add");
        this.keywords.put("authorization", "authorization");
        this.keywords.put("auto", "auto");
        this.keywords.put("backup", "backup");
        this.keywords.put("base64", "base64");
        this.keywords.put("begin", "begin");
        this.keywords.put("between", "between");
        this.keywords.put("binary", "binary");
        this.keywords.put("break", "break");
        this.keywords.put("browse", "browse");
        this.keywords.put("bulk", "bulk");
        this.keywords.put("by", "by");
        this.keywords.put("cascade", "cascade");
        this.keywords.put("case", "case");
        this.keywords.put("cast", "cast");
        this.keywords.put("check", "check");
        this.keywords.put("checkpoint", "checkpoint");
        this.keywords.put("close", "close");
        this.keywords.put("clustered", "clustered");
        this.keywords.put("coalesce", "coalesce");
        this.keywords.put("collate", "collate");
        this.keywords.put("column", "column");
        this.keywords.put("commit", "commit");
        this.keywords.put("compute", "compute");
        this.keywords.put("concat", "concat");
        this.keywords.put("constraint", "constraint");
        this.keywords.put("contains", "contains");
        this.keywords.put("containstable", "containstable");
        this.keywords.put("continue", "continue");
        this.keywords.put("create", "create");
        this.keywords.put("cross", "cross");
        this.keywords.put("cube", "cube");
        this.keywords.put("current", "current");
        this.keywords.put("current_date", "current_date");
        this.keywords.put("current_time", "current_time");
        this.keywords.put("current_timestamp", "current_timestamp");
        this.keywords.put("current_user", "current_user");
        this.keywords.put("cursor", "cursor");
        this.keywords.put("database", "database");
        this.keywords.put("dbcc", "dbcc");
        this.keywords.put("deallocate", "deallocate");
        this.keywords.put("declare", "declare");
        this.keywords.put("default", "default");
        this.keywords.put("delete", "delete");
        this.keywords.put("deny", "deny");
        this.keywords.put("desc", "desc");
        this.keywords.put("disk", "disk");
        this.keywords.put("distinct", "distinct");
        this.keywords.put("distributed", "distributed");
        this.keywords.put("double", "double");
        this.keywords.put("drop", "drop");
        this.keywords.put("dump", "dump");
        this.keywords.put("elements", "elements");
        this.keywords.put("else", "else");
        this.keywords.put("end", "end");
        this.keywords.put("errlvl", "errllvl");
        this.keywords.put("escape", "escape");
        this.keywords.put("except", "except");
        this.keywords.put("exec", "exec");
        this.keywords.put("execute", "execute");
        this.keywords.put("exists", "exists");
        this.keywords.put("exit", "exit");
        this.keywords.put("expand", "expand");
        this.keywords.put("explicit", "explicit");
        this.keywords.put("fast", "fast");
        this.keywords.put("fastfirstrow", "fastfirstrow");
        this.keywords.put("fetch", "fetch");
        this.keywords.put("file", "file");
        this.keywords.put("fillfactor", "fillfactor");
        this.keywords.put("for", "for");
        this.keywords.put("force", "force");
        this.keywords.put("foreign", "foreign");
        this.keywords.put("freetext", "freetext");
        this.keywords.put("freetexttable", "freetexttable");
        this.keywords.put("from", "from");
        this.keywords.put("full", "full");
        this.keywords.put("function", "function");
        this.keywords.put("goto", "goto");
        this.keywords.put("grant", "grant");
        this.keywords.put("group", "group");
        this.keywords.put("hash", "hash");
        this.keywords.put("having", "having");
        this.keywords.put("holdlock", "holdlock");
        this.keywords.put("identity", "identity");
        this.keywords.put("identity_insert", "identity_insert");
        this.keywords.put("identitycol", "identitycol");
        this.keywords.put("if", "if");
        this.keywords.put("in", "in");
        this.keywords.put("index", "index");
        this.keywords.put("inner", "inner");
        this.keywords.put("insert", "insert");
        this.keywords.put("intersect", "intersect");
        this.keywords.put("into", "into");
        this.keywords.put("is", "is");
        this.keywords.put("join", "join");
        this.keywords.put("keep", "keep");
        this.keywords.put("keepfixed", "keepfixed");
        this.keywords.put("key", "key");
        this.keywords.put("kill", "kill");
        this.keywords.put("left", "left");
        this.keywords.put("like", "like");
        this.keywords.put("lineno", "lineno");
        this.keywords.put("load", "load");
        this.keywords.put("loop", "loop");
        this.keywords.put("maxdop", "maxdop");
        this.keywords.put("merge", "merge");
        this.keywords.put("national", "national");
        this.keywords.put("nocheck", "nocheck");
        this.keywords.put("nolock", "nolock");
        this.keywords.put("nonclustered", "nonclustered");
        this.keywords.put("not", "not");
        this.keywords.put("null", "null");
        this.keywords.put("of", "of");
        this.keywords.put("off", "off");
        this.keywords.put("offsets", "offsets");
        this.keywords.put("on", "on");
        this.keywords.put("open", "open");
        this.keywords.put("opendatasource", "opendatasource");
        this.keywords.put("openquery", "openquery");
        this.keywords.put("openrowset", "openrowset");
        this.keywords.put("openxml", "opemxml");
        this.keywords.put("option", "option");
        this.keywords.put("or", "or");
        this.keywords.put("order", "order");
        this.keywords.put("outer", "outer");
        this.keywords.put("over", "over");
        this.keywords.put("paglock", "paglock");
        this.keywords.put("percent", "percent");
        this.keywords.put("plan", "plan");
        this.keywords.put("precision", "precision");
        this.keywords.put("primary", "primary");
        this.keywords.put("print", "print");
        this.keywords.put("proc", "proc");
        this.keywords.put("procedure", "procedure");
        this.keywords.put("public", "public");
        this.keywords.put("raiserror", "raiserror");
        this.keywords.put("raw", "raw");
        this.keywords.put("read", "read");
        this.keywords.put("readcommited", "readcommited");
        this.keywords.put("readpast", "readpast");
        this.keywords.put("readtext", "readtext");
        this.keywords.put("readuncommited", "readuncommited");
        this.keywords.put("reconfigure", "reconfigure");
        this.keywords.put("references", "references");
        this.keywords.put("region", "region");
        this.keywords.put("remote", "remote");
        this.keywords.put("repeatableread", "repeatableread");
        this.keywords.put("replication", "replicatiion");
        this.keywords.put("restore", "restore");
        this.keywords.put("restrict", "restrict");
        this.keywords.put("return", "return");
        this.keywords.put("revoke", "revoke");
        this.keywords.put("right", "right");
        this.keywords.put("robust", "robust");
        this.keywords.put("rollback", "rollback");
        this.keywords.put("rollup", "rollup");
        this.keywords.put("rowcount", "rowcount");
        this.keywords.put("rowguidcol", "rowguidcol");
        this.keywords.put("rowlock", "rowlock");
        this.keywords.put("rule", "rule");
        this.keywords.put("save", "save");
        this.keywords.put("schema", "schema");
        this.keywords.put("select", "select");
        this.keywords.put("serializable", "serializable");
        this.keywords.put("session_user", "session_user");
        this.keywords.put("set", "set");
        this.keywords.put("setuser", "setuser");
        this.keywords.put("shutdown", "shutdown");
        this.keywords.put("some", "some");
        this.keywords.put("statistics", "statistics");
        this.keywords.put("system_user", "system_user");
        this.keywords.put("table", "table");
        this.keywords.put("tablock", "tablock");
        this.keywords.put("tablockx", "tablockx");
        this.keywords.put("textsize", "textsize");
        this.keywords.put("then", "then");
        this.keywords.put("ties", "ties");
        this.keywords.put("to", "to");
        this.keywords.put("top", "top");
        this.keywords.put("tran", "tran");
        this.keywords.put("transaction", "transaction");
        this.keywords.put("trigger", "trigger");
        this.keywords.put("tsequal", "tsequal");
        this.keywords.put("union", "union");
        this.keywords.put("unique", "unique");
        this.keywords.put("update", "update");
        this.keywords.put("updatetext", "updatetext");
        this.keywords.put("updlock", "updlock");
        this.keywords.put("use", "use");
        this.keywords.put("user", "user");
        this.keywords.put("values", "values");
        this.keywords.put("varying", "varying");
        this.keywords.put("view", "view");
        this.keywords.put("views", "views");
        this.keywords.put("waitfor", "waitfor");
        this.keywords.put("when", "when");
        this.keywords.put("where", "where");
        this.keywords.put("while", "while");
        this.keywords.put("with", "with");
        this.keywords.put("writetext", "writetext");
        this.keywords.put("xlock", "xlock");
        this.keywords.put("xmatch", "xmatch");
        this.keywords.put("xml", "xml");
        this.keywords.put("xmldata", "xmldata");
        this.functions.put("region", "region");
        this.functions.put("xmatch", "xmatch");
        this.functions.put("acos", "acos");
        this.functions.put("asin", "asin");
        this.functions.put("atan", "atan");
        this.functions.put("atan2", "atan2");
        this.functions.put("cos", "cos");
        this.functions.put("cot", "cot");
        this.functions.put("sin", "sin");
        this.functions.put("tan", "tan");
        this.functions.put("abs", "abs");
        this.functions.put("ceiling", "ceiling");
        this.functions.put("degrees", "degrees");
        this.functions.put("exp", "exp");
        this.functions.put("floor", "floor");
        this.functions.put("log", "log");
        this.functions.put("log10", "log10");
        this.functions.put("mod", "mod");
        this.functions.put("pi", "pi");
        this.functions.put("power", "power");
        this.functions.put("radians", "radians");
        this.functions.put("sqrt", "sqrt");
        this.functions.put("rand", "rand");
        this.functions.put("round", "round");
        this.functions.put("truncate", "truncate");
        this.functions.put("func", "func");
    }

    private void rewind() {
        if (this.m_nOffset - this.m_nPref >= 0) {
            this.m_nOffset -= this.m_nPref;
            this.m_nPref = 1;
        } else {
            this.m_nOffset = 0;
            this.m_nPref = 1;
        }
    }

    private char getChar() {
        return this.m_strAdql.charAt(this.m_nOffset++);
    }

    private boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '#';
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isOperator(char ch, boolean withstar, boolean withslash) {
        if (ch == '=' || ch == '>' || ch == '<' || ch == '!' || ch == '+' || ch == '-' || ch == '%' || ch == '~' || ch == '|' || ch == '^' || ch == '&') {
            return true;
        }
        if (withstar && ch == '*') {
            return true;
        }
        return withslash && ch == '/';
    }

    private void trim() {
        char c = this.getChar();
        while (c == ' ') {
            c = this.getChar();
        }
        if (c != ' ') {
            this.rewind();
        }
    }

    private ADQLToken parseInStatus_nul(char ch) {
        ADQLToken tkn = null;
        if (this.isLetter(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 11;
        } else if (this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 13;
        } else if (ch == ' ') {
            this.trim();
            this.s = 12;
        } else if (ch == '@') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 0;
        } else if (ch == '\'') {
            this.s = 20;
        } else if (ch == '/') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 18;
        } else if (ch == ':') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 3;
        } else if (ch == '*') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 19;
        } else if (this.isOperator(ch, false, false)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 14;
        } else if (ch == ';') {
            tkn = new Eof();
            this.s = -2;
        } else if (ch == '(') {
            tkn = new LParam();
            this.s = -2;
        } else if (ch == ')') {
            tkn = new RParam();
            this.s = -2;
        } else if (ch == ',') {
            tkn = new Comma();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private boolean isEOF() {
        return this.m_strAdql.length() <= this.m_nOffset;
    }

    private boolean isKeyword(String chs) {
        String chslc = chs.toLowerCase();
        return this.keywords.containsKey(chslc);
    }

    private boolean isFunction(String chs) {
        String chslc = chs.toLowerCase();
        return this.functions.containsKey(chslc);
    }

    private ADQLToken parseInStatus_lit(char ch) throws ParserSyntaxException, ParserExpressionException {
        ADQLToken tkn = null;
        if (this.isLetter(ch) || this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 11;
        } else if (ch == '.') {
            tkn = new DBObject();
            Identifier id = new Identifier();
            id.setValue(this.chs);
            this.chs = "";
            ((DBObject)tkn).addFirst(id);
            this.s = 7;
        } else if (ch == ' ') {
            this.trim();
            if (this.isKeyword(this.chs)) {
                tkn = new Keyword(this.chs);
            } else {
                tkn = new DBObject();
                Identifier id = new Identifier();
                id.setValue(this.chs);
                this.chs = "";
                ((DBObject)tkn).addFirst(id);
            }
            this.s = -2;
        } else if (ch == ':') {
            ArchiveTable at = new ArchiveTable();
            at.setValue(this.chs);
            tkn = new ArchiveTableItem();
            ((ArchiveTableItem)tkn).setArchiveTable(at);
            this.chs = "";
            ADQLToken dbo = this.parseToken();
            if (dbo.getClassType() == 4) {
                ((ArchiveTableItem)tkn).setTableName((DBObject)dbo);
                this.s = -2;
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else if (this.isOperator(ch, true, true) || ch == ',' || ch == ';') {
            tkn = new DBObject();
            Identifier id = new Identifier();
            id.setValue(this.chs);
            this.chs = "";
            ((DBObject)tkn).addFirst(id);
            this.rewind();
            this.s = -2;
        } else if (ch == ')') {
            tkn = new DBObject();
            Identifier id = new Identifier();
            id.setValue(this.chs);
            this.chs = "";
            ((DBObject)tkn).addFirst(id);
            this.rewind();
            this.s = -2;
        } else if (ch == '(') {
            if (this.isFunction(this.chs)) {
                ExplicitFunction exf = new ExplicitFunction();
                exf.setName(this.chs);
                Expression param = null;
                int term = 0;
                int flag = 1;
                ADQLParser pa2 = new ADQLParser();
                pa2.m_strAdql = this.m_strAdql.substring(this.m_nOffset);
                do {
                    pa2.exprs = 0;
                    param = pa2.parseExpression();
                    if (param != null) {
                        exf.addParameter(param);
                        ADQLToken t = param.terminator;
                        term = t.getClassType();
                        if (term == 3) {
                            flag = 1;
                            continue;
                        }
                        if (term == 2) {
                            flag = 0;
                            continue;
                        }
                        flag = -1;
                        continue;
                    }
                    flag = -1;
                } while (flag > 0);
                this.m_nOffset += pa2.m_nOffset;
                if (flag < 0) {
                    DASLog log = new DASLog();
                    log.error(131073);
                    this.s = -1;
                } else {
                    tkn = exf;
                    this.s = -2;
                }
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_str(char ch) {
        DBObject tkn = null;
        if (ch == '\'') {
            tkn = new DBObject();
            QuoteIdentifier id = new QuoteIdentifier();
            id.setValue(this.chs);
            tkn.addFirst(id);
            this.s = 15;
        } else {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 20;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_num(char ch) {
        ADQLInteger tkn = null;
        if (this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 13;
        } else if (ch == 'e' || ch == 'E') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 21;
        } else if (ch == '.') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 16;
        } else if (ch == ' ' || ch == ',' || ch == ')' || ch == ';' || this.isOperator(ch, true, true)) {
            if (ch == ' ') {
                this.trim();
            }
            tkn = new ADQLInteger();
            tkn.setValue(this.chs);
            this.s = -2;
            if (this.isOperator(ch, true, true) || ch == ',' || ch == ')' || ch == ';') {
                this.rewind();
            }
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_at1(char ch) {
        ADQLToken tkn = null;
        if (this.isLetter(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 26;
        } else if (ch == '@') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 1;
        } else if (ch == '\'') {
            this.s = 20;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_at2(char ch) {
        ADQLToken tkn = null;
        if (this.isLetter(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 24;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_sla(char ch) {
        ADQLOperator tkn = null;
        if (this.isDigit(ch) || ch == '(' || this.isLetter(ch) || ch == '\'') {
            tkn = new ADQLOperator(196608);
            this.chs = "";
            this.rewind();
            this.s = -2;
        } else if (ch == '*') {
            this.s = 5;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_cl1(char ch) {
        ADQLToken tkn = null;
        if (ch == ':') {
            this.s = 4;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_cl2(char ch) {
        ADQLToken tkn = null;
        if (this.isLetter(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_op1(char ch) throws ParserSyntaxException {
        ADQLOperator tkn = null;
        if (this.isDigit(ch) || ch == '(') {
            tkn = new ADQLOperator(this.chs);
            this.rewind();
            this.s = -2;
        } else if (this.isOperator(ch, true, true)) {
            if (this.chs.equals(">")) {
                if (ch == '=') {
                    this.chs = String.valueOf(this.chs) + ch;
                    tkn = new ADQLOperator(this.chs);
                    this.s = -2;
                } else {
                    tkn = new ADQLOperator(this.chs);
                    this.rewind();
                    this.s = -2;
                }
            } else if (this.chs.equals("<")) {
                if (ch == '=' || ch == '>') {
                    this.chs = String.valueOf(this.chs) + ch;
                    tkn = new ADQLOperator(this.chs);
                    this.s = -2;
                } else {
                    tkn = new ADQLOperator(this.chs);
                    this.rewind();
                    this.s = -2;
                }
            } else if (this.chs.equals("!")) {
                if (ch == '>' || ch == '<' || ch == '=') {
                    this.chs = String.valueOf(this.chs) + ch;
                    tkn = new ADQLOperator(this.chs);
                    this.s = -2;
                } else {
                    DASLog log = new DASLog();
                    log.error(131073);
                    this.s = -1;
                }
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else {
            tkn = new ADQLOperator(this.chs);
            this.rewind();
            this.s = -2;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_sta(char ch) throws ParserSyntaxException {
        ADQLToken tkn = null;
        if (this.isLetter(ch) || this.isDigit(ch) || ch == '@' || ch == '\'' || ch == '(') {
            tkn = new ADQLOperator(this.chs);
            this.rewind();
            this.s = -2;
        } else if (ch == ' ') {
            this.trim();
            tkn = new Star();
            this.s = -2;
        } else if (ch == ',' || ch == ';' || ch == ')') {
            tkn = new Star();
            this.rewind();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_db1(char ch) {
        ADQLToken tkn = null;
        if (this.isLetter(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 8;
        } else if (ch == '\'') {
            this.s = 9;
        } else if (ch == '*') {
            this.s = 25;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_db2(DBObject dbo, char ch) {
        ADQLToken tkn = null;
        if (this.isLetter(ch) || this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 8;
        } else if (ch == ' ') {
            this.trim();
            if (dbo != null) {
                Identifier id = new Identifier();
                id.setValue(this.chs);
                dbo.addSecond(id);
                this.s = -2;
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else if (ch == ',' || ch == ')' || this.isOperator(ch, true, true) || ch == ';') {
            if (dbo != null) {
                Identifier id = new Identifier();
                id.setValue(this.chs);
                dbo.addSecond(id);
                this.rewind();
                this.s = -2;
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else if (ch == '.') {
            if (dbo != null) {
                Identifier id = new Identifier();
                id.setValue(this.chs);
                dbo.addSecond(id);
                this.s = 7;
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_dq1(char ch) {
        ADQLToken tkn = null;
        if (ch == '\'') {
            this.s = 10;
        } else {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 9;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_dq2(DBObject dbo, char ch) {
        ADQLToken tkn = null;
        if (ch == ' ') {
            this.trim();
            if (dbo != null) {
                Identifier id = new Identifier();
                id.setValue(this.chs);
                dbo.addSecond(id);
                this.s = -2;
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else if (this.isOperator(ch, true, true) || ch == ';' || ch == ')' || ch == ',') {
            if (dbo != null) {
                Identifier id = new Identifier();
                id.setValue(this.chs);
                dbo.addSecond(id);
                this.rewind();
                this.s = -2;
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else if (ch == '.') {
            if (dbo != null) {
                Identifier id = new Identifier();
                id.setValue(this.chs);
                dbo.addSecond(id);
                this.s = 7;
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_tbc(char ch) {
        TableColumns tkn = null;
        if (ch == ' ') {
            this.trim();
            tkn = new TableColumns();
            tkn.setValue(this.chs);
            this.s = -2;
        } else if (this.isOperator(ch, true, true) || ch == ',' || ch == ';' || ch == ')') {
            tkn = new TableColumns();
            tkn.setValue(this.chs);
            this.rewind();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_qlt(char ch) {
        DBObject tkn = null;
        if (ch == ' ' || ch == '.' || this.isOperator(ch, true, true) || ch == ')' || ch == ';' || ch == ',') {
            QuoteIdentifier id = new QuoteIdentifier();
            id.setValue(this.chs);
            tkn = new DBObject();
            tkn.addFirst(id);
            if (ch == '.') {
                this.s = 7;
            } else {
                this.rewind();
                this.s = -2;
            }
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_sn1(char ch) {
        ADQLToken tkn = null;
        if (this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 22;
        } else if (ch == '+' || ch == '-') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 23;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_sn2(char ch) {
        ADQLReal tkn = null;
        if (this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 22;
        } else if (ch == ' ') {
            this.trim();
            tkn = new ADQLReal();
            tkn.setValue(this.chs);
            this.s = -2;
        } else if (ch == ',' || ch == ')' || ch == ';' || this.isOperator(ch, true, true)) {
            tkn = new ADQLReal();
            tkn.setValue(this.chs);
            this.rewind();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_sn3(char ch) {
        ADQLToken tkn = null;
        if (this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 22;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_cm1(char ch) {
        ADQLToken tkn = null;
        if (ch == '*') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 6;
        } else {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 5;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_cm2(char ch) {
        ADQLComment tkn = null;
        if (ch == '/') {
            tkn = new ADQLComment();
            tkn.setValue(this.chs.substring(0, this.chs.length() - 2));
            this.s = -2;
        } else if (ch == '*') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 6;
        } else {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 5;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_rl1(char ch) {
        ADQLReal tkn = null;
        if (this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 17;
        } else if (ch == 'e' || ch == 'E') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 21;
        } else if (ch == ' ') {
            this.trim();
            tkn = new ADQLReal();
            tkn.setValue(this.chs);
            this.s = -2;
        } else if (this.isOperator(ch, true, true) || ch == ';' || ch == ')' || ch == ',') {
            tkn = new ADQLReal();
            tkn.setValue(this.chs);
            this.rewind();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_rl2(char ch) {
        ADQLReal tkn = null;
        if (this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 17;
        } else if (ch == 'e' || ch == 'E') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 21;
        } else if (ch == ' ') {
            this.trim();
            tkn = new ADQLReal();
            tkn.setValue(this.chs);
            this.s = -2;
        } else if (this.isOperator(ch, true, true) || ch == ';' || ch == ')' || ch == ',') {
            tkn = new ADQLReal();
            tkn.setValue(this.chs);
            this.rewind();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_var(char ch) {
        ADQLVariable tkn = null;
        if (this.isLetter(ch) || this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 26;
        } else if (ch == ' ') {
            this.trim();
            tkn = new ADQLVariable();
            tkn.setValue(this.chs);
            this.s = -2;
        } else if (ch == ',' || this.isOperator(ch, true, true) || ch == ';' || ch == ')') {
            tkn = new ADQLVariable();
            tkn.setValue(this.chs);
            this.rewind();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseInStatus_svr(char ch) {
        ADQLSysVariable tkn = null;
        if (this.isLetter(ch) || this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 24;
        } else if (ch == ' ') {
            this.trim();
            tkn = new ADQLSysVariable();
            tkn.setValue(this.chs);
            this.s = -2;
        } else if (ch == '@') {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 0;
        } else if (this.isOperator(ch, true, true) || ch == ';' || ch == ')' || ch == ',') {
            tkn = new ADQLSysVariable();
            tkn.setValue(this.chs);
            this.rewind();
            this.s = -2;
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private boolean isBIFunction(String chs) {
        return false;
    }

    private ADQLToken parseInStatus_bif(char ch) throws ParserSyntaxException, ParserExpressionException {
        ADQLBuiltInFunction tkn = null;
        if (this.isLetter(ch) || this.isDigit(ch)) {
            this.chs = String.valueOf(this.chs) + ch;
            this.s = 2;
        } else if (ch == '(') {
            if (this.isBIFunction(this.chs)) {
                ADQLBuiltInFunction bif = new ADQLBuiltInFunction();
                Expression param = null;
                int term = 0;
                int flag = 1;
                do {
                    if ((param = this.parseExpression()) != null) {
                        bif.addParameter(param);
                        ADQLToken t = this.parseToken();
                        term = t.getClassType();
                        if (term == 3) {
                            flag = 1;
                            continue;
                        }
                        if (term == 2) {
                            flag = 0;
                            continue;
                        }
                        flag = -1;
                        continue;
                    }
                    flag = -1;
                } while (flag > 0);
                if (flag < 0) {
                    DASLog log = new DASLog();
                    log.error(131073);
                    this.s = -1;
                } else {
                    tkn = bif;
                    this.s = -2;
                }
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                this.s = -1;
            }
        } else {
            DASLog log = new DASLog();
            log.error(131073);
            this.s = -1;
        }
        return tkn;
    }

    private ADQLToken parseToken() throws ParserSyntaxException, ParserExpressionException {
        ADQLToken tkn = null;
        ADQLToken tkn0 = null;
        char ch = this.getChar();
        do {
            if (this.s == 12) {
                tkn0 = this.parseInStatus_nul(ch);
            } else if (this.s == 11) {
                tkn0 = this.parseInStatus_lit(ch);
            } else if (this.s == 13) {
                tkn0 = this.parseInStatus_num(ch);
            } else {
                if (this.s == -1) {
                    throw new ParserSyntaxException();
                }
                tkn0 = this.s == 20 ? this.parseInStatus_str(ch) : (this.s == 0 ? this.parseInStatus_at1(ch) : (this.s == 1 ? this.parseInStatus_at2(ch) : (this.s == 18 ? this.parseInStatus_sla(ch) : (this.s == 3 ? this.parseInStatus_cl1(ch) : (this.s == 4 ? this.parseInStatus_cl2(ch) : (this.s == 14 ? this.parseInStatus_op1(ch) : (this.s == 19 ? this.parseInStatus_sta(ch) : (this.s == 7 ? this.parseInStatus_db1(ch) : (this.s == 8 ? this.parseInStatus_db2((DBObject)tkn, ch) : (this.s == 9 ? this.parseInStatus_dq1(ch) : (this.s == 10 ? this.parseInStatus_dq2((DBObject)tkn, ch) : (this.s == 25 ? this.parseInStatus_tbc(ch) : (this.s == 15 ? this.parseInStatus_qlt(ch) : (this.s == 21 ? this.parseInStatus_sn1(ch) : (this.s == 22 ? this.parseInStatus_sn2(ch) : (this.s == 23 ? this.parseInStatus_sn3(ch) : (this.s == 5 ? this.parseInStatus_cm1(ch) : (this.s == 6 ? this.parseInStatus_cm2(ch) : (this.s == 16 ? this.parseInStatus_rl1(ch) : (this.s == 17 ? this.parseInStatus_rl2(ch) : (this.s == 26 ? this.parseInStatus_var(ch) : (this.s == 24 ? this.parseInStatus_svr(ch) : this.parseInStatus_bif(ch)))))))))))))))))))))));
            }
            if (this.s != -2) {
                ch = this.getChar();
            }
            if (tkn0 == null) continue;
            tkn = tkn0;
        } while (this.s != -2);
        this.s = 12;
        this.chs = "";
        return tkn;
    }

    private Expression parseExpr_null(Expression ex, ADQLToken obj) throws ParserSyntaxException, ParserExpressionException {
        switch (obj.getClassType()) {
            case 4: 
            case 10: 
            case 11: 
            case 19: {
                ex.currod = obj;
                this.exprs = 1;
                break;
            }
            case 17: {
                ADQLOperator op = (ADQLOperator)obj;
                if (op.getOpType() == 131074 || op.getOpType() == 131075) {
                    ex.currod = new ADQLInteger();
                    ((ADQLInteger)ex.currod).setValue("0");
                    ex.currop = op;
                    ex.root = op;
                    this.exprs = 2;
                    break;
                }
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                --this.m_nLParam;
            }
            case 0: {
                this.exprs = -1;
                break;
            }
            case 18: {
                this.exprs = 4;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                ex.currod = obj;
                this.exprs = 1;
                break;
            }
            case 1: {
                ++this.m_nLParam;
                ex = this.parseExpression();
                if (ex.terminator.getClassType() == 2) {
                    this.exprs = 1;
                    break;
                }
                this.exprs = -1;
                break;
            }
            case 20: {
                ex.currod = obj;
                this.exprs = -1;
                break;
            }
            default: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
            }
        }
        return ex;
    }

    private Expression parseExpr_od(Expression ex, ADQLToken obj) throws ParserSyntaxException, ParserExpressionException {
        switch (obj.getClassType()) {
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 19: 
            case 22: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
                break;
            }
            case 17: {
                if (ex.root != null) {
                    ex = this.setop(ex, obj);
                } else {
                    ex.root = (ADQLOperator)obj;
                    ex.currop = (ADQLOperator)obj;
                    if (ex.currod != null) {
                        ex.root.setLeft(ex.currod);
                    }
                }
                this.exprs = 3;
                break;
            }
            case 2: {
                --this.m_nLParam;
                this.exprs = -1;
                break;
            }
            case 0: 
            case 3: 
            case 6: {
                this.exprs = -1;
                break;
            }
            default: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
            }
        }
        return ex;
    }

    private Expression parseExpr_op1(Expression ex, ADQLToken obj) throws ParserSyntaxException, ParserExpressionException {
        switch (obj.getClassType()) {
            case 4: 
            case 10: 
            case 11: 
            case 19: {
                ex.currop.setRight(obj);
                this.exprs = 1;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 17: 
            case 18: 
            case 20: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                ex.currod = obj;
                ex.currop.setRight(obj);
                this.exprs = 1;
                break;
            }
            case 7: {
                ex.currop.setRight(obj);
                this.exprs = 1;
                break;
            }
            case 22: {
                break;
            }
            case 1: {
                ++this.m_nLParam;
                ex.currod = this.parseExpression().root;
                ex.currop.setRight(ex.currod);
                this.exprs = 1;
                break;
            }
            default: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
            }
        }
        return ex;
    }

    private Expression parseExpr_op2(Expression ex, ADQLToken obj) throws ParserSyntaxException, ParserExpressionException {
        switch (obj.getClassType()) {
            case 4: 
            case 10: 
            case 11: 
            case 19: {
                ex.currod = obj;
                ex.currop.setRight(obj);
                this.exprs = 1;
                break;
            }
            case 17: {
                ADQLOperator op = (ADQLOperator)obj;
                if (op.getOpType() == 131074 || op.getOpType() == 131075) {
                    ADQLInteger od0 = new ADQLInteger();
                    od0.setValue("0");
                    ex.currop.setRight(od0);
                    ex = this.setop(ex, op);
                    this.exprs = 3;
                    break;
                }
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
                break;
            }
            case 0: 
            case 3: 
            case 6: 
            case 18: 
            case 20: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
                break;
            }
            case 2: {
                --this.m_nLParam;
                ex.currod = obj;
                ex.currop.setRight(obj);
                this.exprs = 1;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                ex.currod = obj;
                ex.currop.setRight(obj);
                this.exprs = 1;
                break;
            }
            case 1: {
                ADQLParser p3 = new ADQLParser();
                p3.m_strAdql = this.m_strAdql.substring(this.m_nOffset);
                ++this.m_nLParam;
                ex.currod = p3.parseExpression().root;
                this.m_nOffset += p3.m_nOffset;
                ex.currop.setRight(ex.currod);
                this.exprs = 1;
                break;
            }
            case 7: 
            case 22: {
                ex.currod = obj;
                ex.currop.setRight(obj);
                this.exprs = 1;
                break;
            }
            default: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
            }
        }
        return ex;
    }

    private Expression parseExpr_sta(Expression ex, ADQLToken obj) throws ParserSyntaxException, ParserExpressionException {
        switch (obj.getClassType()) {
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 17: 
            case 19: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
                break;
            }
            case 2: {
                --this.m_nLParam;
                this.exprs = -1;
                break;
            }
            case 0: 
            case 3: {
                this.exprs = -1;
                break;
            }
            default: {
                DASLog log = new DASLog();
                log.error(131074);
                this.exprs = 6;
            }
        }
        return ex;
    }

    private Expression setop(Expression ex, ADQLToken obj) throws ParserSyntaxException, ParserExpressionException {
        ADQLOperator opnew = (ADQLOperator)obj;
        while (true) {
            if (ex.currop.getPriority() < opnew.getPriority()) {
                opnew.setLeft(ex.currop.getRight());
                ex.currop.setRight(opnew);
                ex.currop = opnew;
                break;
            }
            if (ex.currop == ex.root) {
                opnew.setLeft(ex.root);
                ex.currop = ex.root = opnew;
                break;
            }
            ex.currop = ex.currop.getParent();
        }
        return ex;
    }

    private Expression parseExpression() throws ParserSyntaxException, ParserExpressionException {
        ADQLToken obj = this.parseToken();
        return this.parseExpression0(obj);
    }

    private Expression parseExpression0(ADQLToken obj) throws ParserSyntaxException, ParserExpressionException {
        Object op_rt = null;
        Object op_curr = null;
        Object od = null;
        Expression ex = new Expression();
        while (this.exprs != -1) {
            switch (this.exprs) {
                case 0: {
                    ex = this.parseExpr_null(ex, obj);
                    if (this.exprs != -1) break;
                    obj = ex.terminator;
                    break;
                }
                case 1: {
                    ex = this.parseExpr_od(ex, obj);
                    break;
                }
                case 2: {
                    ex = this.parseExpr_op1(ex, obj);
                    break;
                }
                case 3: {
                    ex = this.parseExpr_op2(ex, obj);
                    break;
                }
                case 4: {
                    ex = this.parseExpr_sta(ex, obj);
                    break;
                }
                default: {
                    DASLog log = new DASLog();
                    log.error(131074);
                    this.exprs = 6;
                }
            }
            if (this.isDelimitor(obj)) {
                this.exprs = -1;
            }
            if (this.exprs == -1) continue;
            obj = this.parseToken();
        }
        ex.terminator = obj;
        this.exprs = 0;
        return ex;
    }

    private boolean isDelimitor(ADQLToken obj) {
        boolean dl = false;
        if (obj.getClassType() == 3 || obj.getClassType() == 2 || obj.getClassType() == 6 || obj.getClassType() == 0) {
            dl = true;
        }
        return dl;
    }

    private void clearDelimiter() {
        this.m_strDelimiter = null;
    }

    private void addDelimiter(ADQLToken deli) {
        if (this.m_strDelimiter == null) {
            this.m_strDelimiter = new LinkedList();
        }
        this.m_strDelimiter.add(deli);
    }

    private boolean checkDelimiter(ADQLToken tkn) {
        boolean ret = false;
        int i = 0;
        while (i < this.m_strDelimiter.size()) {
            ADQLToken deli = (ADQLToken)this.m_strDelimiter.get(i);
            if (tkn.getADQLString().equals(deli.getADQLString())) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    private boolean isSelectTerminator(String k) {
        return k.equalsIgnoreCase("from") || k.equalsIgnoreCase("where") || k.equalsIgnoreCase("group by") || k.equalsIgnoreCase("having") || k.equalsIgnoreCase("order by");
    }

    private boolean isFromTerminator(String k) {
        return k.equalsIgnoreCase("where") || k.equalsIgnoreCase("group by") || k.equalsIgnoreCase("having") || k.equalsIgnoreCase("order by");
    }

    private boolean isWhereTerminator(String k) {
        return k.equalsIgnoreCase("group by") || k.equalsIgnoreCase("having") || k.equalsIgnoreCase("order by");
    }

    private Object[] parseColumn(ADQLToken currtkn) throws ParserSyntaxException, ParserExpressionException {
        ADQLToken tkn = null;
        SelectItem si = null;
        Expression expr = this.parseExpression0(currtkn);
        switch (expr.getRoot().getClassType()) {
            case 10: 
            case 16: 
            case 18: 
            case 19: {
                si = (SelectItem)tkn;
                break;
            }
            case 4: 
            case 17: {
                DASLog log;
                si = new Column(expr.getRoot());
                tkn = expr.terminator;
                if (tkn.getValue().toString().equalsIgnoreCase("as")) {
                    tkn = this.parseToken();
                    if (tkn.getClassType() == 4) {
                        ((Column)si).setAlias((DBObject)tkn);
                        tkn = this.parseToken();
                        if (tkn.getClassType() == 3 || this.isSelectTerminator(tkn.getValue().toString())) {
                            expr.terminator = tkn;
                            break;
                        }
                        log = new DASLog();
                        log.error(131073);
                        log.debug("error location (ADQLParser.parseColumn)");
                        break;
                    }
                    log = new DASLog();
                    log.error(131073);
                    log.debug("error location (ADQLParser.parseColumn)");
                    break;
                }
                if (tkn.getClassType() == 4) {
                    ((Column)si).setAlias((DBObject)tkn);
                    tkn = this.parseToken();
                    if (tkn.getClassType() == 3 || this.isSelectTerminator(tkn.getValue().toString())) {
                        expr.terminator = tkn;
                        break;
                    }
                    log = new DASLog();
                    log.error(131073);
                    log.debug("error location (ADQLParser.parseColumn)");
                    break;
                }
                if (tkn.getClassType() == 3 || this.isSelectTerminator(tkn.getValue().toString())) {
                    expr.terminator = tkn;
                    break;
                }
                log = new DASLog();
                log.error(131073);
                log.debug("error location (ADQLParser.parseColumn)");
                break;
            }
            default: {
                if (expr.getRoot() == null || this.isSelectTerminator(expr.getRoot().getValue().toString())) break;
                DASLog log = new DASLog();
                log.error(131073);
                log.debug("error location (ADQLParser.parseColumn)");
            }
        }
        Object[] ret = new Object[]{si, tkn};
        return ret;
    }

    private Object[] parseTableSource() throws ParserSyntaxException, ParserExpressionException {
        Object[] ret = new Object[2];
        SubTableSource s = null;
        JoinedTable jt = null;
        this.tkn = this.parseToken();
        if (this.tkn.getClassType() == 8) {
            s = new SubTableSource();
            s.setArchiveTableItem((ArchiveTableItem)this.tkn);
            this.tkn = this.parseToken();
            if (this.tkn.getClassType() == 4) {
                s.setAlias((DBObject)this.tkn);
            } else {
                ret[1] = this.tkn;
            }
        } else if (this.tkn.getClassType() == 6 && (this.tkn.getValue().toString().equalsIgnoreCase("inner") || this.tkn.getValue().toString().equalsIgnoreCase("outer") || this.tkn.getValue().toString().equalsIgnoreCase("left") || this.tkn.getValue().toString().equalsIgnoreCase("right") || this.tkn.getValue().toString().equalsIgnoreCase("full"))) {
            ADQLToken tkn2 = this.parseToken();
            if (tkn2.getClassType() == 6 && tkn2.getValue().toString().equalsIgnoreCase("join")) {
                Object[] obj = this.parseTableSource();
                tkn2 = obj[1] == null ? this.parseToken() : (ADQLToken)obj[1];
                if (tkn2.getClassType() == 6 && tkn2.getValue().toString().equalsIgnoreCase("on")) {
                    SearchCondition sc = this.parseCondition(null);
                    jt = (JoinedTable)obj[0];
                    if (this.tkn.getValue().toString().equalsIgnoreCase("inner")) {
                        jt.setJoinType(0);
                    } else if (this.tkn.getValue().toString().equalsIgnoreCase("left")) {
                        jt.setJoinType(1);
                    } else if (this.tkn.getValue().toString().equalsIgnoreCase("right")) {
                        jt.setJoinType(2);
                    } else if (this.tkn.getValue().toString().equalsIgnoreCase("outer")) {
                        jt.setJoinType(3);
                    } else {
                        jt.setJoinType(4);
                    }
                    jt.setOn(sc);
                } else {
                    DASLog log = new DASLog();
                    log.error(131073);
                    log.debug("error location (ADQLParser.parseTableSource)");
                }
            } else {
                DASLog log = new DASLog();
                log.error(131073);
                log.debug("error location (ADQLParser.parseTableSource)");
            }
        } else if (this.tkn.getClassType() == 6 && this.tkn.getValue().toString().equalsIgnoreCase("cross")) {
            ADQLToken tkn2 = this.parseToken();
            if (tkn2.getClassType() == 6 && tkn2.getValue().toString().equalsIgnoreCase("join")) {
                Object[] obj = this.parseTableSource();
                jt = (JoinedTable)obj[0];
                jt.setJoinType(5);
                ret[1] = obj[1];
            }
        } else {
            ret[1] = this.tkn;
        }
        ret[0] = s != null ? s : (jt != null ? jt : null);
        return ret;
    }

    private SearchCondition parseCondition(ADQLToken tkn) throws ParserSyntaxException, ParserExpressionException {
        SearchCondition scroot = null;
        SearchCondition sccurr = null;
        ADQLToken tk = null;
        tk = tkn == null || tkn.getValue().toString().equalsIgnoreCase("where") ? this.parseToken() : tkn;
        while (!this.isWhereTerminator(tk.getValue().toString()) && tk.getClassType() != 0) {
            if (this.isKeyword(tk.getValue().toString())) {
                DASLog log;
                SearchCondition sc0;
                if (tk.getValue().toString().equalsIgnoreCase("AND")) {
                    if (scroot != null) {
                        sc0 = new And();
                        SearchCondition[] rsc = SearchCondition.add(scroot, sccurr, sc0);
                        scroot = rsc[0];
                        sccurr = rsc[1];
                    } else {
                        log = new DASLog();
                        log.error(196631);
                    }
                } else if (tk.getValue().toString().equalsIgnoreCase("OR")) {
                    if (scroot != null) {
                        sc0 = new Or();
                        SearchCondition[] rsc = SearchCondition.add(scroot, sccurr, sc0);
                        scroot = rsc[0];
                        sccurr = rsc[1];
                    } else {
                        log = new DASLog();
                        log.error(196631);
                    }
                } else if (tk.getValue().toString().equalsIgnoreCase("NOT")) {
                    sc0 = null;
                    sc0 = new Not();
                    if (scroot != null) {
                        SearchCondition[] rsc = SearchCondition.add(scroot, sccurr, sc0);
                        scroot = rsc[0];
                        sccurr = rsc[1];
                    } else {
                        scroot = sc0;
                        sccurr = sc0;
                    }
                } else {
                    DASLog log2 = new DASLog();
                    log2.error(131073);
                    log2.debug("error location (ADQLParser.parseCondition)");
                    throw new ParserSyntaxException();
                }
                tk = this.parseToken();
                continue;
            }
            if (tk.getClassType() == 11 && ((Function)tk).getName().equalsIgnoreCase("XMATCH")) {
                XMatch sc0 = new XMatch((Function)tk);
                SearchCondition[] rsc = SearchCondition.add(scroot, sccurr, sc0);
                scroot = rsc[0];
                sccurr = rsc[1];
                tk = this.parseToken();
                continue;
            }
            if (tk.getClassType() == 11 && ((Function)tk).getName().equalsIgnoreCase("REGION")) {
                Region sc0 = new Region((Function)tk);
                SearchCondition[] rsc = SearchCondition.add(scroot, sccurr, sc0);
                scroot = rsc[0];
                sccurr = rsc[1];
                tk = this.parseToken();
                continue;
            }
            if (tk.getClassType() == 4 || tk.getClassType() == 14 || tk.getClassType() == 15 || tk.getClassType() == 11) {
                Expression exp = this.parseExpression0(tk);
                CompareOp sc0 = new CompareOp();
                sc0.setExpression(exp);
                SearchCondition[] rsc = SearchCondition.add(scroot, sccurr, sc0);
                scroot = rsc[0];
                sccurr = rsc[1];
                tk = exp.terminator;
                continue;
            }
            if (tk.getClassType() == 1) {
                SearchCondition[] rsc;
                SearchCondition sc0;
                int flag1 = this.m_nOffset;
                int currLParam = this.m_nLParam;
                Expression exp = this.parseExpression0(tk);
                if (this.m_nLParam == currLParam) {
                    sc0 = new CompareOp();
                    sc0.setExpression(exp);
                    rsc = SearchCondition.add(scroot, sccurr, sc0);
                    scroot = rsc[0];
                    sccurr = rsc[1];
                    tk = exp.terminator;
                    continue;
                }
                this.m_nOffset = flag1;
                sc0 = this.parseCondition(null);
                rsc = SearchCondition.add(scroot, sccurr, sc0);
                scroot = rsc[0];
                sccurr = rsc[1];
                tk = this.parseToken();
                continue;
            }
            if (tk.getClassType() != 2) continue;
            --this.m_nLParam;
            break;
        }
        scroot.terminator = tk;
        return scroot;
    }

    private SelectStatement parseSelectStatement() throws ParserSyntaxException, ParserExpressionException {
        ADQLToken tkn = null;
        SelectStatement ss = null;
        SelectClause sc = new SelectClause();
        try {
            Where wh;
            DASLog log;
            From fm;
            SelectList sl;
            tkn = this.parseToken();
            if (tkn.getClassType() == 6 && tkn.getValue().toString().equalsIgnoreCase("select")) {
                tkn = this.parseToken();
                if (tkn.getClassType() == 6 && tkn.getValue().toString().equalsIgnoreCase("top")) {
                    throw new ParserSyntaxException("TOP is not implemented");
                }
                sl = new SelectList();
                sc.setSelectList(sl);
                while (!this.isSelectTerminator(tkn.getValue().toString())) {
                    Object[] d = this.parseColumn(tkn);
                    sl.addSelectItem((SelectItem)d[0]);
                    tkn = (ADQLToken)d[1];
                    if (tkn.getClassType() == 3) {
                        tkn = this.parseToken();
                        continue;
                    }
                    if (this.isSelectTerminator(tkn.getValue().toString())) continue;
                    DASLog log2 = new DASLog();
                    log2.error(131073);
                    log2.debug("error location (ADQLParser.parseSelectStatement)");
                    throw new ParserSyntaxException("error location (ADQLParser.parseSelectStatement)");
                }
            } else {
                DASLog log3 = new DASLog();
                log3.error(131073);
                log3.debug("error location (ADQLParser.parseSelectStatement)");
                throw new ParserSyntaxException("error location (ADQLParser.parseSelectStatement)");
            }
            sc.setSelectList(sl);
            ss = new SelectStatement();
            ss.setSelectClause(sc);
            if (tkn.getClassType() == 6 && tkn.getValue().toString().equalsIgnoreCase("from")) {
                fm = new From();
                while (!this.isFromTerminator(tkn.getValue().toString()) && tkn.getClassType() != 0) {
                    Object[] obj = this.parseTableSource();
                    if (obj[1] != null) {
                        tkn = (ADQLToken)obj[1];
                    }
                    if (obj[0] == null) continue;
                    if (obj[0].getClass().getName().equalsIgnoreCase("net.ivoa.adql.SubTableSource")) {
                        fm.addSubTableSource((SubTableSource)obj[0]);
                        continue;
                    }
                    if (obj[0].getClass().getName().equalsIgnoreCase("net.ivoa.adql.JoinedTable")) {
                        fm.addJoinedTable((JoinedTable)obj[0]);
                        continue;
                    }
                    DASLog log4 = new DASLog();
                    log4.error(131073);
                    log4.debug("error location (ADQLParser.parseSelectStatement)");
                    throw new ParserSyntaxException("error location (ADQLParser.parseSelectStatement)");
                }
            } else {
                log = new DASLog();
                log.error(131073);
                log.debug("error location (ADQLParser.parseSelectStatement)");
                throw new ParserSyntaxException("error location (ADQLParser.parseSelectStatement)");
            }
            ss.setFrom(fm);
            if (tkn.getClassType() == 6 && tkn.getValue().toString().equalsIgnoreCase("where") && tkn.getClassType() != 0) {
                wh = new Where();
                if (!this.isWhereTerminator(tkn.getValue().toString()) && tkn.getClassType() != 0) {
                    SearchCondition s = this.parseCondition(tkn);
                    wh.setSearchCondition(s);
                    tkn = s.terminator;
                }
            } else {
                if (tkn.getClassType() == 0) {
                    return ss;
                }
                log = new DASLog();
                log.error(131073);
                log.debug("error location (ADQLParser.parseSelectStatement)");
                throw new ParserSyntaxException("error location (ADQLParser.parseSelectStatement)");
            }
            ss.setWhere(wh);
            if (tkn.getClassType() != 6 || !tkn.getValue().toString().equalsIgnoreCase("having")) {
                if (tkn.getClassType() == 0) {
                    return ss;
                }
                log = new DASLog();
                log.error(131073);
                log.debug("error location (ADQLParser.parseSelectStatement)");
                throw new ParserSyntaxException("error location (ADQLParser.parseSelectStatement)");
            }
        }
        catch (Exception e) {
            throw new ParserSyntaxException("error location (ADQLParser.parseSelectStatement):" + e.getMessage());
        }
        return ss;
    }

    private From parseFrom() throws ParserSyntaxException {
        return null;
    }

    public SelectStatement parse(String adql) throws ParserSyntaxException, ParserExpressionException {
        this.m_strAdql = adql;
        if (this.m_strAdql.charAt(this.m_strAdql.length() - 1) != ';') {
            this.m_strAdql = String.valueOf(this.m_strAdql) + ";";
        }
        SelectStatement ss = this.parseSelectStatement();
        return ss;
    }

    public static void main(String[] args) {
        String str = "select s.glon,s.glat,s.g from SDSS:Star2 s where s.g>17.2 and (s.g<20.2 or s.g-s.r>=-0.3) and s.g-s.r<=0 and s.u-s.g>=0.8 and s.u-s.g<=1.2 and (s.u-4*s.g+3*s.r<=1.8 or s.u-2*s.g+s.r<=1.3 or s.u-14/15*s.g-1/15*s.r<=1.8 or s.u-2*s.g+s.r<=1.8)";
        System.out.println("origin:" + str);
        ADQLParser ap = new ADQLParser();
        ap.m_strAdql = str;
        if (ap.m_strAdql.charAt(ap.m_strAdql.length() - 1) != ';') {
            ap.m_strAdql = String.valueOf(ap.m_strAdql) + ";";
        }
        Object tkn = null;
        try {
            SelectStatement ss = ap.parse(str);
            From fm = ss.getFrom();
            System.out.print("\nFrom ");
            Vector ts = fm.getTableSources();
            int i = 0;
            while (i < ts.size()) {
                SubTableSource sts = (SubTableSource)ts.get(i);
                System.out.println(sts.getArchiveTableItem().getADQLString());
                ++i;
            }
            Where wh = ss.getWhere();
            SearchCondition scd = wh.getSearchCondition();
            System.out.println("where " + scd.getADQLString());
            DBObject[] scdobjs = scd.getAllDBObjects();
            System.out.println(scdobjs.length);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

