/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.engine.client;

import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.china.vo.das.engine.dASService.stubs.AsynchQuery;
import org.china.vo.das.engine.dASService.stubs.CreateResource;
import org.china.vo.das.engine.dASService.stubs.CreateResourceResponse;
import org.china.vo.das.engine.dASService.stubs.DASFactoryPortType;
import org.china.vo.das.engine.dASService.stubs.DASPortType;
import org.china.vo.das.engine.dASService.stubs.GetAllResource;
import org.china.vo.das.engine.dASService.stubs.GetMetaColumns;
import org.china.vo.das.engine.dASService.stubs.GetMetaTables;
import org.china.vo.das.engine.dASService.stubs.Start;
import org.china.vo.das.engine.dASService.stubs.SynchQuery;
import org.china.vo.das.engine.dASService.stubs.service.DASFactoryServiceAddressingLocator;
import org.china.vo.das.engine.dASService.stubs.service.DASServiceAddressingLocator;
import org.china.vo.das.engine.impl.DASNamespaces;
import org.globus.axis.util.Util;
import org.oasis.wsn.GetCurrentMessage;
import org.oasis.wsn.GetCurrentMessageResponse;
import org.oasis.wsn.InvalidTopicExpressionFaultType;
import org.oasis.wsn.NoCurrentMessageOnTopicFaultType;
import org.oasis.wsn.PauseFailedFaultType;
import org.oasis.wsn.PauseSubscription;
import org.oasis.wsn.PauseSubscriptionResponse;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.ResumeFailedFaultType;
import org.oasis.wsn.ResumeSubscription;
import org.oasis.wsn.ResumeSubscriptionResponse;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeCreationFailedFaultType;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicNotSupportedFaultType;
import org.oasis.wsn.TopicPathDialectUnknownFaultType;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.ResourceNotDestroyedFaultType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.lifetime.TerminationTimeChangeRejectedFaultType;
import org.oasis.wsrf.lifetime.UnableToSetTerminationTimeFaultType;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.InvalidQueryExpressionFaultType;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.InvalidSetResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.properties.QueryEvaluationErrorFaultType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.SetResourcePropertiesResponse;
import org.oasis.wsrf.properties.SetResourceProperties_Element;
import org.oasis.wsrf.properties.SetResourceProperties_PortType;
import org.oasis.wsrf.properties.SetResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.properties.UnableToModifyResourcePropertyFaultType;
import org.oasis.wsrf.properties.UnknownQueryExpressionDialectFaultType;
import org.oasis.wsrf.properties.UpdateType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;

public class DASClient
implements DASNamespaces {
    private DASPortType port = null;
    String instanceURI = "http://192.168.3.3:8080/wsrf/services/DASService";
    String factoryURI = "http://192.168.3.3:8080/wsrf/services/DASFactoryService";
    private DASFactoryPortType factoryPort = null;
    private static EndpointReferenceType instanceEPR;

    static {
        Util.registerTransport();
    }

    public DASPortType getPort(String factoryURI, String instanceURI) throws URI.MalformedURIException, ServiceException, RemoteException {
        DASFactoryServiceAddressingLocator factoryLocator = new DASFactoryServiceAddressingLocator();
        DASServiceAddressingLocator locator = new DASServiceAddressingLocator();
        EndpointReferenceType factoryEPR = new EndpointReferenceType();
        factoryEPR.setAddress((AttributedURI)new Address(factoryURI));
        this.factoryPort = factoryLocator.getDASFactoryPortTypePort(factoryEPR);
        CreateResourceResponse createResponse = this.factoryPort.createResource(new CreateResource());
        instanceEPR = createResponse.getEndpointReference();
        instanceEPR.setAddress((AttributedURI)new Address(instanceURI));
        DASPortType port = locator.getDASPortTypePort(instanceEPR);
        return port;
    }

    public DASClient(EndpointReferenceType instanceEPR) throws ServiceException {
        DASServiceAddressingLocator locator = new DASServiceAddressingLocator();
        this.port = locator.getDASPortTypePort(instanceEPR);
    }

    public DASClient(String factoryURI, String instanceURI) throws URI.MalformedURIException, RemoteException, ServiceException {
        this.port = this.getPort(factoryURI, instanceURI);
        this.factoryURI = factoryURI;
        this.instanceURI = instanceURI;
    }

    public String synchQuery(String adql, int format) throws RemoteException {
        String retVal = this.port.synchQuery(new SynchQuery(adql, format)).getSynchQueryReturn();
        return retVal;
    }

    public void AsynchQuery(String adql, int format, String targetURL) throws RemoteException {
        this.port.asynchQuery(new AsynchQuery(adql, format, targetURL));
    }

    public void start() throws RemoteException {
        this.port.start(new Start());
    }

    public String getAllResource() throws RemoteException {
        String retVal = this.port.getAllResource(new GetAllResource()).getGetAllResourceReturn();
        return retVal;
    }

    public String getMetaTables(String dataNodeName) throws RemoteException {
        String retVal = this.port.getMetaTables(new GetMetaTables(dataNodeName)).getGetMetaTablesReturn();
        return retVal;
    }

    public String getMetaColumns(String dataNodeName, String tableName) throws RemoteException {
        String retVal = this.port.getMetaColumns(new GetMetaColumns(dataNodeName, tableName)).getGetMetaColumnsReturn();
        return retVal;
    }

    public void destroy() throws ResourceNotDestroyedFaultType, org.oasis.wsrf.lifetime.ResourceUnknownFaultType, RemoteException {
        this.port.destroy(new Destroy());
    }

    public SetTerminationTimeResponse setTerminationTime(SetTerminationTime setTerminationTimeRequest) throws UnableToSetTerminationTimeFaultType, org.oasis.wsrf.lifetime.ResourceUnknownFaultType, TerminationTimeChangeRejectedFaultType, RemoteException {
        return this.port.setTerminationTime(setTerminationTimeRequest);
    }

    public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.port.getResourceProperty(getResourcePropertyRequest);
    }

    public GetMultipleResourcePropertiesResponse getMultipleResourceProperties(GetMultipleResourceProperties_Element getMultipleResourcePropertiesRequest) throws InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.port.getMultipleResourceProperties(getMultipleResourcePropertiesRequest);
    }

    public SetResourcePropertiesResponse setResourceProperties(SetResourceProperties_Element setResourcePropertiesRequest) throws InvalidResourcePropertyQNameFaultType, UnableToModifyResourcePropertyFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, SetResourcePropertyRequestFailedFaultType, InvalidSetResourcePropertiesRequestContentFaultType, RemoteException {
        return this.port.setResourceProperties(setResourcePropertiesRequest);
    }

    public QueryResourcePropertiesResponse queryResourceProperties(QueryResourceProperties_Element queryResourcePropertiesRequest) throws InvalidResourcePropertyQNameFaultType, InvalidQueryExpressionFaultType, QueryEvaluationErrorFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, UnknownQueryExpressionDialectFaultType, RemoteException {
        return this.port.queryResourceProperties(queryResourcePropertiesRequest);
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage getCurrentMessageRequest) throws RemoteException, TopicNotSupportedFaultType, InvalidTopicExpressionFaultType, NoCurrentMessageOnTopicFaultType, ResourceUnknownFaultType {
        return this.port.getCurrentMessage(getCurrentMessageRequest);
    }

    public SubscribeResponse subscribe(Subscribe subscribeRequest) throws RemoteException, TopicNotSupportedFaultType, InvalidTopicExpressionFaultType, SubscribeCreationFailedFaultType, ResourceUnknownFaultType, TopicPathDialectUnknownFaultType {
        return this.port.subscribe(subscribeRequest);
    }

    public PauseSubscriptionResponse pauseSubscription(PauseSubscription pauseSubscriptionRequest) throws RemoteException, PauseFailedFaultType, ResourceUnknownFaultType {
        return this.port.pauseSubscription(pauseSubscriptionRequest);
    }

    public ResumeSubscriptionResponse resumeSubscription(ResumeSubscription resumeSubscriptionRequest) throws RemoteException, ResumeFailedFaultType, ResourceUnknownFaultType {
        return this.port.resumeSubscription(resumeSubscriptionRequest);
    }

    public GetResourcePropertyResponse getStatusAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_STATUS);
    }

    public GetResourcePropertyResponse getExecplanAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_EXECPLAN);
    }

    public GetResourcePropertyResponse getFormatAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_FORMAT);
    }

    public GetResourcePropertyResponse getTargetURLAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_TARGETURL);
    }

    public GetResourcePropertyResponse getQueryResultAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_QUERYRESULT);
    }

    public GetResourcePropertyResponse getSubmitTimeAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_SUBMITTIME);
    }

    public GetResourcePropertyResponse getStartTimeAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_STARTTIME);
    }

    public GetResourcePropertyResponse getEndTimeAsResourceProperty() throws Exception, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, RemoteException {
        return this.getResourceProperty(RP_ENDTIME);
    }

    public static void updateRP(QName rpQName, String value) throws Exception {
        WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
        SetResourceProperties_PortType port = locator.getSetResourcePropertiesPort(instanceEPR);
        UpdateType update = new UpdateType();
        MessageElement msg = new MessageElement(rpQName, (Object)value);
        update.set_any(new MessageElement[]{msg});
        SetResourceProperties_Element request = new SetResourceProperties_Element();
        request.setUpdate(update);
        port.setResourceProperties(request);
    }

    public static EndpointReferenceType getinstanceEPR() {
        return instanceEPR;
    }

    public static void main(String[] args) {
        String instanceURI = "http://192.168.3.3:8080/wsrf/services/DASService";
        String factoryURI = "http://192.168.3.3:8080/wsrf/services/DASFactoryService";
        String str = "select s.ra, s.decl from SDSS:Star2 s where REGION('circle J2000 180 50 0.5')";
        try {
            DASClient client = new DASClient(factoryURI, instanceURI);
            System.out.println("RPR:" + instanceEPR.toString());
            client.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

