/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.engine;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.china.vo.das.engine.WaitingQueue;
import org.china.vo.das.engine.WorkThreadPool;
import org.china.vo.das.engine.impl.DASResource;
import org.china.vo.das.service.ExecPlan;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.properties.RequestStatus;
import uk.org.ogsadai.client.toolkit.properties.UnknownPropertyException;
import uk.org.ogsadai.client.toolkit.sessions.Session;

public class WorkThread
extends Thread {
    private ExecPlan execplan = null;
    private DASResource sessionTMP = null;
    private Session ogsadaiSession = null;
    WaitingQueue instance = WaitingQueue.getInstance();
    WorkThreadPool instancepool = WorkThreadPool.getInstance();
    int dnnum = 0;
    private int workThreadID;
    SimpleDateFormat formatter = null;

    public int getWorkThreadID() {
        return this.workThreadID;
    }

    public void setWorkThreadID(int workThreadID) {
        this.workThreadID = workThreadID;
    }

    public WorkThread(DASResource session) {
        this.sessionTMP = session;
        this.execplan = session.getExecplan();
        this.execplan.setTargetURL(session.getTargetURL());
        this.execplan.setFormat(session.getFormat());
        this.dnnum = this.execplan.getARDNCount();
        this.instance.getWaitingQueue().remove(session);
        this.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public void run() {
        int i = 0;
        while (i < this.dnnum) {
            try {
                this.execplan.runNextDN(i);
            }
            catch (Exception dpe) {
                this.sessionTMP.setStatus("Error");
                dpe.printStackTrace();
            }
            ++i;
        }
        this.ogsadaiSession = this.execplan.getSession();
        try {
            RequestStatus statusTMP = this.ogsadaiSession.getStatus();
            while (statusTMP.equals(RequestStatus.UNSTARTED) || statusTMP.equals(RequestStatus.INITIALISING) || statusTMP.equals(RequestStatus.PROCESSING)) {
                statusTMP = this.ogsadaiSession.getStatus();
                this.sessionTMP.setStatus(statusTMP.toString());
                System.out.println("Session (" + this.sessionTMP.getID().toString() + "), Status is==================:" + statusTMP.toString());
                Thread.sleep(8000L);
            }
            this.sessionTMP.setStatus(statusTMP.toString());
        }
        catch (UnknownPropertyException e1) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setQueryResult(this.execplan.getQueryResult());
            this.sessionTMP.setStatus("COMPLETED");
            System.out.println("Session (" + this.sessionTMP.getID().toString() + "), Status is==================:COMPLETED");
        }
        catch (ServiceCommsException e1) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setStatus("Error");
            e1.printStackTrace();
        }
        catch (ResourceUnknownException e1) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setStatus("Error");
            e1.printStackTrace();
        }
        catch (ServerException e1) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setStatus("Error");
            e1.printStackTrace();
        }
        catch (DataFormatException e1) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setStatus("Error");
            e1.printStackTrace();
        }
        catch (AuthorisationException e1) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setStatus("Error");
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setStatus("Error");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.sessionTMP.setEndTime(this.formatter.format(new Date()));
            this.sessionTMP.setStatus("Error");
            e.printStackTrace();
        }
        this.instancepool.selfSubtract();
    }
}

