/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.engine;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.china.vo.das.datanode.DataResourceMap;
import org.china.vo.das.engine.WaitingQueue;
import org.china.vo.das.engine.WorkThread;
import org.china.vo.das.engine.WorkThreadPool;
import org.china.vo.das.engine.impl.DASResource;
import org.china.vo.das.log.DASLog;
import org.china.vo.das.registry.RegistryProxy;
import org.china.vo.das.service.ServerConfigure;
import org.xml.sax.SAXException;

public class LoopThread
implements Runnable {
    private static LoopThread instanceLT = null;
    private int NUM = 8;
    DASLog daslog;
    DataResourceMap drm = DataResourceMap.getInstance();
    WaitingQueue instance = WaitingQueue.getInstance();
    private int waitingNum;
    private int workthreadNum;
    private DASResource session = null;
    private String status = null;
    long nowtime = 0L;
    long submittime = 0L;
    int sessionIdlePeriod = 120000;
    int discoverPeriod = 6000000;
    long discovertime = 0L;
    boolean flag_s = true;
    boolean flag_a = true;
    Iterator it;
    Iterator it_s;
    WorkThreadPool instancepool = WorkThreadPool.getInstance();
    SimpleDateFormat format = null;

    private LoopThread() {
        this.daslog = new DASLog();
        this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ServerConfigure sc = new ServerConfigure();
        String filepath = sc.getFilePath();
        try {
            sc.parseConfigureFile(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.NUM = Integer.parseInt(sc.getWorkthreadnum());
        this.sessionIdlePeriod = Integer.parseInt(sc.getSessionidleperiod());
        this.discoverPeriod = Integer.parseInt(sc.getDiscoverperiod());
    }

    public static synchronized LoopThread getInstance() {
        if (instanceLT == null) {
            instanceLT = new LoopThread();
        }
        return instanceLT;
    }

    public void run() {
        RegistryProxy rp = new RegistryProxy();
        try {
            rp.discover(this.drm);
            this.instance.getWaitingQueue().clear();
            System.out.println("The WaitingQueue Has Been Cleared");
            this.discovertime = new Date().getTime();
        }
        catch (Exception e) {
            this.daslog.error(196610);
        }
        while (true) {
            WorkThread workthread;
            this.workthreadNum = this.instancepool.getWorkTheadNum();
            LinkedList linkedListTMP = new LinkedList(this.instance.getWaitingQueue());
            LinkedList linkedListTMP_S = new LinkedList(this.instance.getWaitingQueue());
            this.it = linkedListTMP.iterator();
            this.it_s = linkedListTMP_S.iterator();
            this.waitingNum = this.instance.getWaitingQueue().size();
            this.nowtime = new Date().getTime();
            System.out.println("Now WaitingNum is =====================:" + this.waitingNum);
            System.out.println("Now WorkThreadNum is =====================:" + this.workthreadNum);
            this.flag_s = true;
            while (this.waitingNum > 0 && this.workthreadNum < this.NUM && this.it_s.hasNext() && this.flag_s) {
                this.session = (DASResource)this.it_s.next();
                this.status = this.session.getStatus();
                System.out.println("Session (" + this.session.getID().toString() + "), Status is==========" + this.session.getStatus());
                if (this.status.toLowerCase().equals("preparing")) {
                    try {
                        this.submittime = this.format.parse(this.session.getSubmitTime()).getTime();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (this.nowtime - this.submittime > (long)this.sessionIdlePeriod) {
                        this.instance.getWaitingQueue().remove(this.session);
                        this.it_s.remove();
                    } else if (this.it_s.hasNext()) {
                        this.session = (DASResource)this.it_s.next();
                    }
                }
                if (this.status.equals("FirstClient")) {
                    this.instance.getWaitingQueue().remove(this.session);
                    this.it_s.remove();
                    System.out.println("Session (" + this.session.getID().toString() + "), FirstClient, Has Been Delete From WaitingQueue!");
                }
                if (this.status.equals("Error")) {
                    this.instance.getWaitingQueue().remove(this.session);
                    this.it_s.remove();
                    System.out.println("Session (" + this.session.getID().toString() + "), Error, Has Been Delete From WaitingQueue!");
                }
                if (!this.status.toLowerCase().equals("waiting") || !this.session.getTargetURL().equals("")) continue;
                workthread = new WorkThread(this.session);
                this.session.setStatus("PROCESSING");
                this.session.setStartTime(this.format.format(new Date()));
                workthread.setWorkThreadID(this.workthreadNum);
                workthread.start();
                this.instancepool.selfAdd();
                this.flag_s = false;
            }
            this.flag_a = true;
            while (this.waitingNum > 0 && this.workthreadNum < this.NUM - 3 && this.it.hasNext() && this.flag_a) {
                this.session = (DASResource)this.it.next();
                this.status = this.session.getStatus();
                if (this.status.toLowerCase().equals("preparing")) {
                    try {
                        this.submittime = this.format.parse(this.session.getSubmitTime()).getTime();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (this.nowtime - this.submittime > (long)this.sessionIdlePeriod) {
                        this.it.remove();
                    } else if (this.it.hasNext()) {
                        this.session = (DASResource)this.it.next();
                    }
                }
                if (this.status.equals("FirstClient")) {
                    this.it.remove();
                }
                if (this.status.equals("Error")) {
                    this.it.remove();
                }
                if (!this.status.toLowerCase().equals("waiting") || this.session.getTargetURL().equals("")) continue;
                workthread = new WorkThread(this.session);
                this.session.setStatus("PROCESSING");
                this.session.setStartTime(this.format.format(new Date()));
                workthread.setWorkThreadID(this.workthreadNum);
                workthread.start();
                this.instancepool.selfAdd();
                this.flag_a = false;
            }
            if (this.nowtime - this.discovertime > (long)this.discoverPeriod) {
                this.discovertime = this.nowtime;
                try {
                    rp.discover(this.drm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(8000L);
                continue;
            }
            catch (Exception e) {
                e.getMessage();
                continue;
            }
            break;
        }
    }
}

