/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.datanode;

import java.net.MalformedURLException;
import java.util.Vector;
import org.china.vo.das.exceptions.CheckDNColumnsException;
import org.china.vo.das.exceptions.CheckDNTableException;
import org.china.vo.das.exceptions.DataNodePerformException;
import org.china.vo.das.exceptions.GetTableTypeException;
import org.china.vo.das.registry.MDDataResource;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.ResourceBusyException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.service.DataService;

public class DataResource {
    private MDDataResource drMDDataResource;

    public Response perform(ActivityRequest ar) throws DataNodePerformException, ServiceCommsException, MalformedURLException, ServerException, ResourceUnknownException, AuthorisationException, ResourceBusyException, RequestException {
        String handle = this.getDRurl();
        String id = this.getDRname();
        DataService service = GenericServiceFetcher.getInstance().getDataService(handle, id);
        Response response = service.perform((Request)ar);
        System.out.println(response.getAsString());
        return response;
    }

    public void setDrMDDataResource(MDDataResource drMDDataResource) {
        this.drMDDataResource = drMDDataResource;
    }

    public MDDataResource getDrMDDataResource() {
        return this.drMDDataResource;
    }

    public int getTableType() throws GetTableTypeException {
        String dntype = this.drMDDataResource.getDNType();
        int ntype = 1;
        if (dntype.equalsIgnoreCase("spectra")) {
            ntype = 3;
        }
        return ntype;
    }

    public String getDRurl() {
        return this.drMDDataResource.getService().getInterfaces().getInterfaceURL();
    }

    public String getDRname() {
        return this.drMDDataResource.getIdentity().getTitle();
    }

    public boolean checkDNTable(String TableName) throws CheckDNTableException {
        return this.drMDDataResource.hasTable(TableName);
    }

    public boolean checkDNColumns(String TableName, Vector ColumnName) throws CheckDNColumnsException, CheckDNTableException {
        boolean hascol = true;
        int i = 0;
        while (i < ColumnName.size()) {
            if (!this.drMDDataResource.hasColumn(TableName, (String)ColumnName.get(i))) {
                hascol = false;
            }
            ++i;
        }
        return hascol;
    }

    public String getMDDataResourceString() {
        return this.drMDDataResource.getXmlString();
    }

    public static void main(String[] args) {
    }
}

