/*
 * Decompiled with CFR 0.152.
 */
package org.china.vo.das.converters.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.china.vo.das.converters.resultset.VOTableColumnStrategyFactory;
import uk.org.ogsadai.converters.resultset.ColumnStrategyFactory;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;
import uk.org.ogsadai.converters.resultset.StrategicResultSetHandler;

public class VOTableResultSetHandler
extends StrategicResultSetHandler
implements ResultSetHandler {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private final String ROWSTART_TAG = "<TR>\n";
    private final String ROWEND_TAG = "</TR>";
    private final String COLSTART_TAG = "<TD>";
    private final String COLEND_TAG = "</TD>\n";

    public VOTableResultSetHandler(ResultSet rs) throws ResultSetHandlerException {
        super(rs, (ColumnStrategyFactory)new VOTableColumnStrategyFactory());
    }

    public void header(StringBuffer output, ResultSet rs) throws ResultSetHandlerException {
        try {
            StringBuffer header = new StringBuffer();
            header.append("<?xml version=\"1.0\"?>\n ");
            header.append("<VOTABLE version=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.ivoa.net/xml/VOTable/VOTable/v1.1\">\n");
            header.append(" <COOSYS ID=\"J2000\" equinox=\"J2000.\" epoch=\"J2000.\" system=\"eq_FK5\"/> \n");
            header.append(this.metadata(rs.getMetaData()));
            header.append("\n<DATA>\n<TABLEDATA>\n");
            output.append(header);
        }
        catch (Exception e) {
            throw new ResultSetHandlerException((Throwable)e);
        }
    }

    public void rowStart(StringBuffer output) {
        output.append("<TR>\n");
    }

    public void columnStart(StringBuffer output) {
        output.append("<TD>");
    }

    public void columnEnd(StringBuffer output) {
        output.append("</TD>\n");
    }

    public void rowEnd(StringBuffer output) {
        output.append("</TR>");
    }

    public void footer(StringBuffer output) {
        output.append("</TABLEDATA>\n</DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>");
    }

    private String properties(ResultSet rs) throws ResultSetHandlerException {
        try {
            int rowsetType;
            String property;
            StringBuffer properties = new StringBuffer("<properties>\n");
            properties.append("<command></command>\n");
            properties.append("<concurrency>");
            properties.append(rs.getConcurrency());
            properties.append("</concurrency>\n");
            properties.append("<datasource></datasource>\n");
            properties.append("<escape-processing>true</escape-processing>\n");
            try {
                property = String.valueOf(rs.getFetchDirection());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<fetch-direction>");
            properties.append(property);
            properties.append("</fetch-direction>\n");
            try {
                property = String.valueOf(rs.getFetchSize());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<fetch-size>");
            properties.append(property);
            properties.append("</fetch-size>\n");
            properties.append("<isolation-level>0</isolation-level>\n");
            properties.append("<key-columns></key-columns>\n");
            properties.append("<map></map>\n");
            Statement statement = rs.getStatement();
            try {
                property = String.valueOf(statement.getMaxFieldSize());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<max-field-size>");
            properties.append(property);
            properties.append("</max-field-size>\n");
            try {
                property = String.valueOf(statement.getMaxRows());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<max-rows>");
            properties.append(property);
            properties.append("</max-rows>\n");
            try {
                property = String.valueOf(statement.getQueryTimeout());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<query-timeout>");
            properties.append(property);
            properties.append("</query-timeout>\n");
            properties.append("<read-only>true</read-only>\n");
            try {
                rowsetType = rs.getType();
            }
            catch (Exception e) {
                rowsetType = -1;
            }
            String sType = "";
            switch (rowsetType) {
                case 1003: {
                    sType = "ResultSet.TYPE_FORWARD_ONLY";
                    break;
                }
                case 1004: {
                    sType = "ResultSet.TYPE_SCROLL_INSENSITIVE";
                    break;
                }
                case 1005: {
                    sType = "ResultSet.TYPE_SCROLL_SENSITIVE";
                }
            }
            properties.append("<rowset-type>");
            properties.append(sType);
            properties.append("</rowset-type>\n");
            properties.append("<show-deleted>false</show-deleted>\n");
            properties.append("<table-name></table-name>\n");
            properties.append("<url></url>\n");
            properties.append("<sync-provider>\n");
            properties.append("<sync-provider-name/>\n");
            properties.append("<sync-provider-vendor/>\n");
            properties.append("<sync-provider-version/>\n");
            properties.append("<sync-provider-grade/>\n");
            properties.append("<data-source-lock/>\n");
            properties.append("</sync-provider>\n");
            properties.append("</properties>\n");
            return properties.toString();
        }
        catch (Exception e) {
            throw new ResultSetHandlerException((Throwable)e);
        }
    }

    private String metadata(ResultSetMetaData metaData) throws ResultSetHandlerException {
        try {
            StringBuffer metadata = new StringBuffer(" <RESOURCE name=\"" + metaData.getCatalogName(1) + "\">\n");
            metadata.append("<TABLE name=\"" + metaData.getTableName(1) + "\">\n");
            metadata.append(" <DESCRIPTION>The query service is from China-VO</DESCRIPTION>\n");
            metadata.append(" <PARAM name=\"\" datatype=\"\" ucd=\"phys.size;instr.tel\" unit=\"\" value=\"\"/>\n");
            int noOfCols = metaData.getColumnCount();
            int i = 1;
            while (i <= noOfCols) {
                metadata.append("<FIELD ");
                metadata.append("name=\"");
                metadata.append(metaData.getColumnName(i));
                metadata.append("\" label=\"");
                metadata.append(metaData.getColumnLabel(i));
                metadata.append("\" ID=\"");
                metadata.append("col" + i);
                if (metaData.getColumnLabel(i).startsWith("spfileurl")) {
                    metadata.append("\" ucd=\"");
                    metadata.append("meta.ref.uri.spec");
                } else {
                    metadata.append("\" ucd=\"");
                    metadata.append("");
                }
                metadata.append("\" ref=\"");
                metadata.append("J2000");
                metadata.append("\" datatype=\"");
                metadata.append(metaData.getColumnTypeName(i));
                metadata.append("\" width=\"");
                metadata.append(metaData.getScale(i));
                metadata.append("\" precision=\"");
                if (metaData.getColumnType(i) == 2004) {
                    metadata.append("0");
                } else {
                    metadata.append(metaData.getPrecision(i));
                }
                metadata.append("\" unit=\"");
                metadata.append("");
                metadata.append("\" arraysize=\"");
                metadata.append("");
                metadata.append("\">\n");
                metadata.append("<DESCRIPTION>");
                metadata.append(metaData.getSchemaName(i));
                metadata.append("</DESCRIPTION>\n");
                metadata.append("</FIELD>\n");
                ++i;
            }
            return metadata.toString();
        }
        catch (Exception e) {
            throw new ResultSetHandlerException((Throwable)e);
        }
    }
}

