/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.adql;

import java.util.Vector;
import net.ivoa.adql.ADQLOperator;
import net.ivoa.adql.ADQLToken;
import net.ivoa.adql.DBObject;
import net.ivoa.adql.ExplicitFunction;
import net.ivoa.adql.Expression;
import net.ivoa.adql.SelectItem;
import net.ivoa.adql.SubExpression;

public abstract class Function
extends SelectItem
implements SubExpression {
    String name;
    Vector parameters = null;
    int currIndex = 0;

    public Function() {
        this.type = 10;
    }

    public String getADQLString() {
        String ret = (String)this.getValue();
        return ret;
    }

    public Object getValue() {
        ADQLToken op;
        String p = "";
        int i = 0;
        i = 0;
        while (i < this.parameters.size() - 1) {
            op = ((Expression)this.parameters.get(i)).getRoot();
            p = String.valueOf(p) + op.getValue().toString() + ", ";
            ++i;
        }
        op = ((Expression)this.parameters.get(i)).getRoot();
        p = String.valueOf(p) + op.getValue().toString();
        return String.valueOf(this.name) + "(" + p + ")";
    }

    public void setName(String n) {
        this.name = n;
    }

    public void addParameter(Expression e) {
        if (this.parameters == null) {
            this.parameters = new Vector();
        }
        this.parameters.add(e);
    }

    public String getName() {
        return this.name;
    }

    public Expression getFirstParameter() {
        if (this.parameters != null && this.parameters.size() > 0) {
            this.currIndex = 1;
            return (Expression)this.parameters.get(0);
        }
        return null;
    }

    public Expression getNextParameter() {
        if (this.parameters != null && this.parameters.size() > this.currIndex) {
            return (Expression)this.parameters.get(this.currIndex++);
        }
        return null;
    }

    public void replaceAliasName(String oldname, String newname) {
        Expression exp = this.getFirstParameter();
        while (exp != null) {
            this.replaceAliasNameForParam(exp, oldname, newname);
            exp = this.getNextParameter();
        }
    }

    public void replaceAliasNameForParam(Expression exp, String oldname, String newname) {
        ADQLToken dbo = exp.getRoot();
        if (dbo != null && dbo.getClassType() == 4) {
            if (((DBObject)dbo).getSecond(0) != null && ((DBObject)dbo).getFirst().getADQLString().equals(oldname)) {
                ((DBObject)dbo).rename(newname);
            }
        } else if (dbo != null && dbo.getClassType() == 17) {
            ((ADQLOperator)dbo).replaceAliasName(oldname, newname);
        } else if (dbo != null && dbo.getClassType() == 11) {
            ((ExplicitFunction)dbo).replaceAliasName(oldname, newname);
        }
    }

    public Vector getDBObjectList() {
        Vector lsttot = new Vector();
        Expression exp = this.getFirstParameter();
        while (exp != null) {
            Vector lst = this.getDBObjectList0(exp);
            lsttot.addAll(lst);
            exp = this.getNextParameter();
        }
        return lsttot;
    }

    private Vector getDBObjectList0(Expression exp) {
        Vector<DBObject> lst = new Vector<DBObject>();
        ADQLToken dbo = exp.getRoot();
        if (dbo != null) {
            if (dbo.getClassType() == 17) {
                Vector lstLeft = ((ADQLOperator)dbo).getDBObjectList();
                lst.addAll(lstLeft);
            } else if (dbo.getClassType() == 4) {
                DBObject lft = (DBObject)dbo;
                if (lft.getSecond(0) != null) {
                    lst.add(lft);
                }
            } else if (dbo.getClassType() == 11) {
                Vector lstLeft = ((ExplicitFunction)dbo).getDBObjectList();
                lst.addAll(lstLeft);
            }
        }
        return lst;
    }
}

