/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.adql;

import java.util.Vector;
import net.ivoa.adql.ADQLToken;
import net.ivoa.adql.DBObject;
import net.ivoa.adql.ExplicitFunction;
import org.china.vo.das.exceptions.ParserSyntaxException;
import org.china.vo.das.log.DASLog;

public class ADQLOperator
extends ADQLToken {
    public static final int op_slash = 196608;
    public static final int op_star = 196609;
    public static final int op_plus = 131074;
    public static final int op_minus = 131075;
    public static final int op_gt = 65540;
    public static final int op_ge = 65541;
    public static final int op_lt = 65542;
    public static final int op_le = 65543;
    public static final int op_assign = 8;
    public static final int op_noteq = 65545;
    private int optype = 196608;
    private ADQLToken od_left;
    private ADQLToken od_right;
    private ADQLOperator parent;
    private int priority;

    public ADQLOperator(int op) {
        this.type = 17;
        this.optype = 196608;
        this.priority = this.optype & 0xFFFF0000;
        this.parent = null;
        this.od_left = null;
        this.od_right = null;
    }

    public int getPriority() {
        return this.optype & 0xFFFF0000;
    }

    public ADQLOperator(String op) throws ParserSyntaxException {
        this.optype = ADQLOperator.convertOpType(op);
        if (this.optype < 0) {
            DASLog log = new DASLog();
            log.error(131073);
            throw new ParserSyntaxException();
        }
        this.type = 17;
    }

    public static int convertOpType(String op) {
        int optp = -1;
        if (op.equals("=")) {
            optp = 8;
        } else if (op.equals("+")) {
            optp = 131074;
        } else if (op.equals("-")) {
            optp = 131075;
        } else if (op.equals("*")) {
            optp = 196609;
        } else if (op.equals("/")) {
            optp = 196608;
        } else if (op.equals(">")) {
            optp = 65540;
        } else if (op.equals("<")) {
            optp = 65542;
        } else if (op.equals(">=")) {
            optp = 65541;
        } else if (op.equals("<=")) {
            optp = 65543;
        } else if (op.equals("!=")) {
            optp = 65545;
        }
        return optp;
    }

    public int getOpType() {
        return this.optype;
    }

    public Object getValue() {
        String ex = "";
        if (this.od_left != null) {
            ex = this.od_left.getClassType() == 17 ? "(" + this.od_left.getValue().toString() + ")" : (this.od_left.getClassType() == 4 ? ((DBObject)this.od_left).getValue().toString() : this.od_left.getValue().toString());
        }
        String strop = "";
        switch (this.optype) {
            case 196608: {
                strop = "/";
                break;
            }
            case 196609: {
                strop = "*";
                break;
            }
            case 131074: {
                strop = "+";
                break;
            }
            case 131075: {
                strop = "-";
                break;
            }
            case 65540: {
                strop = ">";
                break;
            }
            case 65541: {
                strop = ">=";
                break;
            }
            case 65542: {
                strop = "<";
                break;
            }
            case 65543: {
                strop = "<=";
                break;
            }
            case 8: {
                strop = "=";
                break;
            }
            case 65545: {
                strop = "!=";
            }
        }
        ex = String.valueOf(ex) + strop;
        if (this.od_right != null) {
            ex = this.od_right.getClassType() == 17 ? String.valueOf(ex) + "(" + this.od_right.getValue().toString() + ")" : (this.od_right.getClassType() == 4 ? String.valueOf(ex) + ((DBObject)this.od_right).getValue().toString() : String.valueOf(ex) + this.od_right.getValue().toString());
        }
        return ex;
    }

    public void setParent(ADQLOperator p) {
        this.parent = p;
    }

    public ADQLOperator getParent() {
        return this.parent;
    }

    public void setLeft(ADQLToken od) {
        if (od.getClassType() == 17) {
            ((ADQLOperator)od).setParent(this);
        }
        this.od_left = od;
    }

    public void setRight(ADQLToken od) {
        if (od.getClassType() == 17) {
            ((ADQLOperator)od).setParent(this);
        }
        this.od_right = od;
    }

    public ADQLToken getLeft() {
        return this.od_left;
    }

    public ADQLToken getRight() {
        return this.od_right;
    }

    public String getADQLString() {
        String ret = "";
        ret = this.getValue().toString();
        return ret;
    }

    public Vector getDBObjectList() {
        Vector lstLeft;
        Vector<DBObject> lst = new Vector<DBObject>();
        if (this.od_left != null) {
            if (this.od_left.getClassType() == 17) {
                lstLeft = ((ADQLOperator)this.od_left).getDBObjectList();
                lst.addAll(lstLeft);
            } else if (this.od_left.getClassType() == 4) {
                DBObject lft = (DBObject)this.od_left;
                if (lft.getSecond(0) != null) {
                    lst.add(lft);
                }
            } else if (this.od_left.getClassType() == 11) {
                lstLeft = ((ExplicitFunction)this.od_left).getDBObjectList();
                lst.addAll(lstLeft);
            }
        }
        if (this.od_right != null) {
            if (this.od_right.getClassType() == 17) {
                Vector lstRight = ((ADQLOperator)this.od_right).getDBObjectList();
                lst.addAll(lstRight);
            } else if (this.od_right.getClassType() == 4) {
                DBObject rt = (DBObject)this.od_right;
                if (rt.getSecond(0) != null) {
                    lst.add(rt);
                }
            } else if (this.od_right.getClassType() == 11) {
                lstLeft = ((ExplicitFunction)this.od_right).getDBObjectList();
                lst.addAll(lstLeft);
            }
        }
        return lst;
    }

    public Vector getAliasList() {
        Vector dblist = this.getDBObjectList();
        Vector<String> list = new Vector<String>();
        int i = 0;
        while (i < dblist.size()) {
            list.add(((DBObject)dblist.get(i)).getFirst().getADQLString());
            ++i;
        }
        return list;
    }

    public void replaceAliasName(String oname, String nname) {
        if (this.od_left != null) {
            if (this.od_left.getClassType() == 17) {
                ((ADQLOperator)this.od_left).replaceAliasName(oname, nname);
            } else if (this.od_left.getClassType() == 4) {
                DBObject lft = (DBObject)this.od_left;
                if (lft.getSecond(0) != null && lft.getFirst().getADQLString().equals(oname)) {
                    lft.rename(nname);
                }
            } else if (this.od_left.getClassType() == 11) {
                ((ExplicitFunction)this.od_left).replaceAliasName(oname, nname);
            }
        }
        if (this.od_right != null) {
            if (this.od_right.getClassType() == 17) {
                ((ADQLOperator)this.od_right).replaceAliasName(oname, nname);
            } else if (this.od_right.getClassType() == 4) {
                DBObject rt = (DBObject)this.od_right;
                if (rt.getSecond(0) != null && rt.getFirst().getADQLString().equals(oname)) {
                    rt.rename(nname);
                }
            } else if (this.od_right.getClassType() == 11) {
                ((ExplicitFunction)this.od_right).replaceAliasName(oname, nname);
            }
        }
    }
}

