/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.samples.management;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.impl.BaseResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.samples.management.AxisService;
import org.w3c.dom.Element;

public class AxisServiceProperty
extends BaseResourceProperty {
    private AxisService service;
    private String propertyName;
    private Map map;
    private String separator;
    static /* synthetic */ Class class$java$lang$String;

    public AxisServiceProperty(AxisService service, String propertyName) {
        this(service, propertyName, null);
    }

    public AxisServiceProperty(AxisService service, String propertyName, String separator) {
        super(AxisServiceProperty.getMetaData(new QName("http://xml.apache.org/axis/wsdd/", propertyName), separator));
        this.service = service;
        this.propertyName = propertyName;
        this.separator = separator;
        this.map = service.getWSDDService().getParametersTable();
    }

    private static ResourcePropertyMetaData getMetaData(QName rpName, String separator) {
        return new SimpleResourcePropertyMetaData(rpName, 0, separator == null ? 1 : Integer.MAX_VALUE, false, class$java$lang$String == null ? (class$java$lang$String = AxisServiceProperty.class$("java.lang.String")) : class$java$lang$String, false);
    }

    public void add(Object value) {
        String currentValue = (String)this.map.get(this.propertyName);
        if (currentValue == null) {
            this.put(value);
            return;
        }
        if (this.separator == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        currentValue = currentValue + this.separator + this.convert(value);
        this.put(currentValue);
    }

    public boolean remove(Object value) {
        String currentValue = (String)this.map.get(this.propertyName);
        if (currentValue == null) {
            return false;
        }
        value = this.convert(value);
        if (this.separator == null) {
            if (currentValue.equals(value)) {
                this.remove();
                return true;
            }
            return false;
        }
        List values = this.toList(currentValue);
        if (values.remove(value)) {
            this.put(this.toString(values));
            return true;
        }
        return false;
    }

    public Object get(int index) {
        String currentValue = (String)this.map.get(this.propertyName);
        if (this.separator != null) {
            currentValue = (String)this.toList(currentValue).get(index);
        }
        return currentValue;
    }

    public void set(int index, Object value) {
        if (this.separator == null) {
            if (index != 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.put(value);
        } else {
            String currentValue = (String)this.map.get(this.propertyName);
            List values = this.toList(currentValue);
            values.set(index, this.convert(value));
            this.put(this.toString(values));
        }
    }

    public void clear() {
        this.remove();
    }

    public int size() {
        String currentValue = (String)this.map.get(this.propertyName);
        if (this.separator == null) {
            return currentValue == null ? 0 : 1;
        }
        if (currentValue == null) {
            return 0;
        }
        return this.toList(currentValue).size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        ArrayList<String> list = null;
        String currentValue = (String)this.map.get(this.propertyName);
        if (this.separator == null) {
            if (currentValue == null) {
                list = new ArrayList<String>(0);
            } else {
                list = new ArrayList(1);
                list.add(currentValue);
            }
        } else {
            list = currentValue == null ? new ArrayList(0) : this.toList(currentValue);
        }
        return list.iterator();
    }

    private void remove() {
        this.service.undeploy();
        this.map.remove(this.propertyName);
        this.service.deploy();
    }

    private void put(Object newValue) {
        this.service.undeploy();
        this.map.put(this.propertyName, this.convert(newValue));
        this.service.deploy();
    }

    private List toList(String value) {
        ArrayList<String> values = new ArrayList<String>();
        if (value != null) {
            StringTokenizer tokens = new StringTokenizer(value, this.separator);
            while (tokens.hasMoreTokens()) {
                values.add(tokens.nextToken());
            }
        }
        return values;
    }

    private String toString(List values) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            buf.append(values.get(i));
            if (i + 1 >= values.size()) continue;
            buf.append(this.separator);
        }
        return buf.toString();
    }

    public SOAPElement[] toSOAPElements() throws SerializationException {
        if (this.separator == null) {
            return this.toSOAPElementSingle();
        }
        return this.toSOAPElementMultiple();
    }

    private SOAPElement[] toSOAPElementSingle() throws SerializationException {
        String currentValue = (String)this.map.get(this.propertyName);
        SOAPElement[] elements = null;
        boolean nillable = this.metaData.isNillable();
        QName name = this.metaData.getName();
        if (currentValue == null) {
            if (nillable) {
                elements = new SOAPElement[]{ObjectSerializer.toSOAPElement((Object)currentValue, (QName)name, (boolean)nillable)};
            }
        } else {
            elements = new SOAPElement[]{ObjectSerializer.toSOAPElement((Object)currentValue, (QName)name, (boolean)nillable)};
        }
        return elements;
    }

    private SOAPElement[] toSOAPElementMultiple() throws SerializationException {
        String currentValue = (String)this.map.get(this.propertyName);
        SOAPElement[] elements = null;
        boolean nillable = this.metaData.isNillable();
        QName name = this.metaData.getName();
        if (currentValue == null) {
            if (nillable) {
                elements = new SOAPElement[]{ObjectSerializer.toSOAPElement(null, (QName)name, (boolean)nillable)};
            }
        } else {
            List list = this.toList(currentValue);
            elements = new SOAPElement[list.size()];
            Iterator iter = list.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object value = iter.next();
                elements[i++] = ObjectSerializer.toSOAPElement(value, (QName)name, (boolean)nillable);
            }
        }
        return elements;
    }

    public Element[] toElements() throws SerializationException {
        if (this.separator == null) {
            return this.toElementSingle();
        }
        return this.toElementMultiple();
    }

    private Element[] toElementSingle() throws SerializationException {
        String currentValue = (String)this.map.get(this.propertyName);
        Element[] values = null;
        boolean nillable = this.metaData.isNillable();
        QName name = this.metaData.getName();
        if (currentValue == null) {
            if (nillable) {
                values[0] = ObjectSerializer.toElement((Object)currentValue, (QName)name, (boolean)nillable);
            }
        } else {
            values = new Element[]{ObjectSerializer.toElement((Object)currentValue, (QName)name, (boolean)nillable)};
        }
        return values;
    }

    private Element[] toElementMultiple() throws SerializationException {
        String currentValue = (String)this.map.get(this.propertyName);
        Element[] values = null;
        boolean nillable = this.metaData.isNillable();
        QName name = this.metaData.getName();
        if (currentValue == null) {
            if (nillable) {
                values = new Element[]{ObjectSerializer.toElement(null, (QName)name, (boolean)nillable)};
            }
        } else {
            List list = this.toList(currentValue);
            values = new Element[list.size()];
            Iterator iter = list.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object value = iter.next();
                values[i++] = ObjectSerializer.toElement(value, (QName)name, (boolean)nillable);
            }
        }
        return values;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

