/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.samples.management;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.XMLUtils;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.samples.management.AxisPropertySet;
import org.globus.wsrf.samples.management.AxisServiceProperty;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AxisService
implements Resource,
ResourceProperties {
    public static final QName RP_SET = new QName("http://xml.apache.org/axis/wsdd/", "ServiceWSDD");
    public static final QName WSDL = new QName("http://xml.apache.org/axis/wsdd/", "wsdlFile");
    public static final QName PROVIDER = new QName("http://xml.apache.org/axis/wsdd/", "provider");
    private ResourcePropertySet propSet;
    private WSDDService service;
    private WSDDDeployment deployment;

    public AxisService(WSDDDeployment deployment, WSDDService service) {
        this.deployment = deployment;
        this.service = service;
        this.propSet = new AxisPropertySet(RP_SET, this);
        Object prop = null;
        LockableHashtable wsddParameters = service.getParametersTable();
        Iterator iter = wsddParameters.entrySet().iterator();
        String name = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof String)) continue;
            name = (String)entry.getKey();
            prop = name.equals("providers") ? new AxisServiceProperty(this, name, " ") : new AxisServiceProperty(this, name);
            this.propSet.add((ResourceProperty)prop);
        }
        try {
            prop = new ReflectionResourceProperty(WSDL, "WSDLFile", (Object)this);
            this.propSet.add((ResourceProperty)prop);
            prop = new ReflectionResourceProperty(PROVIDER, "Provider", (Object)this);
            this.propSet.add((ResourceProperty)prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    public WSDDService getWSDDService() {
        return this.service;
    }

    public String getWSDLFile() {
        return this.service.getServiceDesc().getWSDLFile();
    }

    public void setWSDLFile(String file) {
        this.undeploy();
        this.service.getServiceDesc().setWSDLFile(file);
        this.deploy();
    }

    public QName getProvider() {
        return this.service.getProviderQName();
    }

    public void setProvider(QName name) {
        this.undeploy();
        this.service.setProviderQName(name);
        this.deploy();
    }

    void undeploy() {
        this.deployment.undeployService(this.service.getQName());
    }

    void deploy() {
        StringWriter writer = new StringWriter();
        SerializationContext context = new SerializationContext((Writer)writer, null);
        context.setPretty(true);
        try {
            this.service.writeToContext(context);
            writer.close();
            Document doc = XMLUtils.newDocument((InputSource)new InputSource(new StringReader(writer.getBuffer().toString())));
            WSDDService newService = new WSDDService(doc.getDocumentElement());
            this.deployment.deployService(newService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

