/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.samples.counter.client;

import com.counter.CounterPortType;
import com.counter.CreateCounter;
import com.counter.CreateCounterResponse;
import com.counter.service.CounterServiceAddressingLocator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.axis.util.Util;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.core.notification.service.SubscriptionManagerServiceAddressingLocator;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.impl.security.descriptor.GSISecureConvAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.samples.counter.Counter;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;

public class CounterClient
extends BaseClient
implements NotifyCallback {
    boolean called = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        CounterClient client = new CounterClient();
        try {
            client.parse(args);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        CounterServiceAddressingLocator locator = new CounterServiceAddressingLocator();
        NotificationConsumerManager consumer = null;
        CounterPortType port = locator.getCounterPortTypePort(client.getEPR());
        client.setOptions((Stub)port);
        CreateCounterResponse createResponse = port.createCounter(new CreateCounter());
        EndpointReferenceType counterEPR = createResponse.getEndpointReference();
        counterEPR.getProperties().get_any()[0].getValue();
        CounterPortType counterPort = locator.getCounterPortTypePort(counterEPR);
        client.setOptions((Stub)counterPort);
        String scheme = client.getEPR().getAddress().getScheme();
        if (scheme.equals("https")) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
            consumer = NotificationConsumerManager.getInstance(properties);
        } else {
            consumer = NotificationConsumerManager.getInstance();
        }
        consumer.startListening();
        EndpointReferenceType consumerEPR = null;
        Authorization authorization = (Authorization)((Stub)counterPort)._getProperty("org.globus.security.authorization");
        if (authorization != null) {
            ResourceSecurityDescriptor resDesc = new ResourceSecurityDescriptor();
            String authz = "none";
            if (authorization instanceof SelfAuthorization) {
                authz = "self";
            } else if (authorization instanceof IdentityAuthorization) {
                GridMap gridMap = new GridMap();
                gridMap.map(((IdentityAuthorization)authorization).getIdentity(), "temp");
                resDesc.setGridMap(gridMap);
                authz = "gridmap";
            }
            resDesc.setAuthz(authz);
            Vector<Object> authMethod = new Vector<Object>();
            authMethod.add(GSISecureMsgAuthMethod.BOTH);
            authMethod.add(GSISecureConvAuthMethod.BOTH);
            authMethod.add(GSITransportAuthMethod.BOTH);
            resDesc.setAuthMethods(authMethod, true);
            consumerEPR = consumer.createNotificationConsumer((NotifyCallback)client, resDesc);
        } else {
            consumerEPR = consumer.createNotificationConsumer((NotifyCallback)client);
        }
        Subscribe request = new Subscribe();
        request.setUseNotify(Boolean.TRUE);
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicExpression = new TopicExpressionType();
        topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
        topicExpression.setValue((Object)Counter.VALUE);
        request.setTopicExpression(topicExpression);
        EndpointReferenceType subscriptionEPR = counterPort.subscribe(request).getSubscriptionReference();
        SubscriptionManagerServiceAddressingLocator subscriptionManagerLocator = new SubscriptionManagerServiceAddressingLocator();
        SubscriptionManager subscriptionPort = subscriptionManagerLocator.getSubscriptionManagerPort(subscriptionEPR);
        CounterPortType addPort = locator.getCounterPortTypePort(counterEPR);
        client.setOptions((Stub)addPort);
        addPort.add(3);
        CounterClient counterClient = client;
        synchronized (counterClient) {
            ((Object)((Object)client)).wait(30000L);
            if (!client.called) {
                System.err.println("Did not receive notification in time!");
            }
        }
        GetResourcePropertyResponse getRPResponse = counterPort.getResourceProperty(Counter.VALUE);
        System.out.println("Counter has value: " + getRPResponse.get_any()[0].getValue());
        addPort.add(10);
        client.setOptions((Stub)subscriptionPort);
        subscriptionPort.destroy(new Destroy());
        CounterPortType destroyPort = locator.getCounterPortTypePort(counterEPR);
        client.setOptions((Stub)destroyPort);
        destroyPort.destroy(new Destroy());
        Object var20_22 = null;
        if (consumer == null) return;
        try {
            consumer.stopListening();
            return;
        }
        catch (Exception ee) {}
        return;
        {
            catch (Exception e) {
                if (client.isDebugMode()) {
                    FaultHelper.printStackTrace((Throwable)e);
                } else {
                    System.err.println("Error: " + FaultHelper.getMessage((Throwable)e));
                }
                System.exit(2);
                Object var20_23 = null;
                if (consumer == null) return;
                try {
                    consumer.stopListening();
                    return;
                }
                catch (Exception ee) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (consumer == null) throw throwable;
            try {
                consumer.stopListening();
                throw throwable;
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(List topicPath, EndpointReferenceType producer, Object message) {
        ResourcePropertyValueChangeNotificationType changeMessage = ((ResourcePropertyValueChangeNotificationElementType)message).getResourcePropertyValueChangeNotification();
        if (changeMessage != null) {
            System.out.println("Got notification with value: " + changeMessage.getNewValue().get_any()[0].getValue());
        }
        CounterClient counterClient = this;
        synchronized (counterClient) {
            this.called = true;
            ((Object)((Object)this)).notify();
        }
    }

    static {
        Util.registerTransport();
    }
}

