/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.samples.counter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.samples.counter.Counter;
import org.globus.wsrf.utils.FilePersistenceHelper;
import org.globus.wsrf.utils.SubscriptionPersistenceUtils;

public class PersistentCounter
extends Counter
implements PersistenceCallback,
RemoveCallback {
    private FilePersistenceHelper persistenceHelper;

    public void setValue(int value) {
        super.setValue(value);
        try {
            this.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setTerminationTime(Calendar time) {
        super.setTerminationTime(time);
        try {
            this.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object create() throws Exception {
        Object key = super.create();
        this.store();
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(ResourceKey key) throws ResourceException {
        int value;
        block8: {
            File file = this.getKeyAsFile(key.getValue());
            if (!file.exists()) {
                throw new NoSuchResourceException();
            }
            this.initialize(key.getValue());
            FileInputStream fis = null;
            value = 0;
            try {
                try {
                    fis = new FileInputStream(file);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    value = ois.readInt();
                    this.terminationTime = (Calendar)ois.readObject();
                    SubscriptionPersistenceUtils.loadSubscriptionListeners((TopicList)this.getTopicList(), (ObjectInputStream)ois);
                }
                catch (Exception e) {
                    throw new ResourceException("Failed to load resource", (Throwable)e);
                }
                Object var7_7 = null;
                if (fis == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ee) {}
            fis.close();
        }
        this.value.set(0, (Object)new Integer(value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store() throws ResourceException {
        File file;
        File tmpFile;
        block8: {
            FileOutputStream fos = null;
            tmpFile = null;
            try {
                try {
                    tmpFile = File.createTempFile("counter", ".tmp", this.getPersistenceHelper().getStorageDirectory());
                    fos = new FileOutputStream(tmpFile);
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeInt((Integer)this.value.get(0));
                    oos.writeObject(this.terminationTime);
                    SubscriptionPersistenceUtils.storeSubscriptionListeners((TopicList)this.getTopicList(), (ObjectOutputStream)oos);
                }
                catch (Exception e) {
                    if (tmpFile == null) throw new ResourceException("Failed to store resource", (Throwable)e);
                    tmpFile.delete();
                    throw new ResourceException("Failed to store resource", (Throwable)e);
                }
                Object var5_5 = null;
                if (fos == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ee) {}
            fos.close();
        }
        if ((file = this.getKeyAsFile(this.key)).exists()) {
            file.delete();
        }
        if (tmpFile.renameTo(file)) return;
        tmpFile.delete();
        throw new ResourceException("Failed to store resource");
    }

    private File getKeyAsFile(Object key) throws InvalidResourceKeyException {
        if (key instanceof Integer) {
            return this.getPersistenceHelper().getKeyAsFile(key);
        }
        throw new InvalidResourceKeyException();
    }

    public void remove() throws ResourceException {
        this.getPersistenceHelper().remove(this.key);
    }

    protected synchronized FilePersistenceHelper getPersistenceHelper() {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new FilePersistenceHelper(this.getClass(), ".ser");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.persistenceHelper;
    }
}

